/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util.http;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.FutureRequestExecutionService;
import org.apache.http.impl.client.HttpRequestFutureTask;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.util.http.HttpClient;
import org.jasig.cas.util.http.HttpMessage;
import org.jasig.cas.util.http.SimpleHttpClient$AjcClosure1;
import org.jasig.cas.util.http.SimpleHttpClient$AjcClosure3;
import org.jasig.cas.util.http.SimpleHttpClient$AjcClosure5;
import org.jasig.cas.util.http.SimpleHttpClient$AjcClosure7;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.Assert;

final class SimpleHttpClient
implements HttpClient,
Serializable,
DisposableBean {
    private static final long serialVersionUID = -4949380008568071855L;
    private static final Logger LOGGER;
    private final List<Integer> acceptableCodes;
    private final CloseableHttpClient httpClient;
    private final FutureRequestExecutionService requestExecutorService;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public SimpleHttpClient(List<Integer> acceptableCodes, CloseableHttpClient httpClient, FutureRequestExecutionService requestExecutorService) {
        this.acceptableCodes = ImmutableList.copyOf(acceptableCodes);
        this.httpClient = httpClient;
        this.requestExecutorService = requestExecutorService;
    }

    @Override
    public boolean sendMessageToEndPoint(HttpMessage message) {
        HttpMessage httpMessage = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)httpMessage);
        Object[] objectArray = new Object[]{this, httpMessage, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClient$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @Override
    public boolean isValidEndPoint(String url) {
        String string = url;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClient$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @Override
    public boolean isValidEndPoint(URL url) {
        URL uRL = url;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)uRL);
        Object[] objectArray = new Object[]{this, uRL, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClient$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public void destroy() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClient$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Deprecated
    public void setExecutorService(@NotNull ExecutorService executorService) {
        LOGGER.warn("setExecutorService() is deprecated and has no effect. Consider using SimpleHttpClientFactoryBean instead.");
    }

    @Deprecated
    public void setAcceptableCodes(int[] acceptableCodes) {
        LOGGER.warn("setAcceptableCodes() is deprecated and has no effect. Consider using SimpleHttpClientFactoryBean instead.");
    }

    @Deprecated
    public void setConnectionTimeout(int connectionTimeout) {
        LOGGER.warn("setConnectionTimeout() is deprecated and has no effect. Consider using SimpleHttpClientFactoryBean instead.");
    }

    @Deprecated
    public void setReadTimeout(int readTimeout) {
        LOGGER.warn("setReadTimeout() is deprecated and has no effect. Consider using SimpleHttpClientFactoryBean instead.");
    }

    @Deprecated
    public void setFollowRedirects(boolean follow) {
        LOGGER.warn("setFollowRedirects() is deprecated and has no effect. Consider using SimpleHttpClientFactoryBean instead.");
    }

    @Deprecated
    public void setSSLSocketFactory(SSLSocketFactory factory) {
        LOGGER.warn("setSSLSocketFactory() is deprecated and has no effect. Consider using SimpleHttpClientFactoryBean instead.");
    }

    @Deprecated
    public void setHostnameVerifier(HostnameVerifier verifier) {
        LOGGER.warn("setHostnameVerifier() is deprecated and has no effect. Consider using SimpleHttpClientFactoryBean instead.");
    }

    static {
        SimpleHttpClient.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(SimpleHttpClient.class);
    }

    static final /* synthetic */ boolean sendMessageToEndPoint_aroundBody0(SimpleHttpClient ajc$this, HttpMessage message, JoinPoint joinPoint) {
        Assert.notNull((Object)ajc$this.httpClient);
        try {
            HttpPost request = new HttpPost(message.getUrl().toURI());
            request.addHeader("Content-Type", message.getContentType());
            StringEntity entity = new StringEntity(message.getMessage(), ContentType.create((String)message.getContentType()));
            request.setEntity((HttpEntity)entity);
            HttpRequestFutureTask task = ajc$this.requestExecutorService.execute((HttpUriRequest)request, (HttpContext)HttpClientContext.create(), (ResponseHandler)new BasicResponseHandler());
            if (message.isAsynchronous()) {
                return true;
            }
            return StringUtils.isNotBlank((CharSequence)((CharSequence)task.get()));
        }
        catch (RejectedExecutionException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    static final /* synthetic */ boolean isValidEndPoint_aroundBody2(SimpleHttpClient ajc$this, String url, JoinPoint joinPoint) {
        try {
            URL u = new URL(url);
            return ajc$this.isValidEndPoint(u);
        }
        catch (MalformedURLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final /* synthetic */ boolean isValidEndPoint_aroundBody4(SimpleHttpClient ajc$this, URL url, JoinPoint joinPoint) {
        Assert.notNull((Object)ajc$this.httpClient);
        HttpEntity entity = null;
        try {
            try (CloseableHttpResponse response = ajc$this.httpClient.execute((HttpUriRequest)new HttpGet(url.toURI()));){
                int responseCode = response.getStatusLine().getStatusCode();
                for (int acceptableCode : ajc$this.acceptableCodes) {
                    if (responseCode != acceptableCode) continue;
                    LOGGER.debug("Response code from server matched {}.", (Object)responseCode);
                    boolean bl = true;
                    EntityUtils.consumeQuietly((HttpEntity)entity);
                    return bl;
                }
                LOGGER.debug("Response code did not match any of the acceptable response codes. Code returned was {}", (Object)responseCode);
                if (responseCode == 500) {
                    String value = response.getStatusLine().getReasonPhrase();
                    LOGGER.error("There was an error contacting the endpoint: {}; The error was:\n{}", (Object)url.toExternalForm(), (Object)value);
                }
                entity = response.getEntity();
            }
            EntityUtils.consumeQuietly((HttpEntity)entity);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            EntityUtils.consumeQuietly(entity);
        }
        return false;
    }

    static final /* synthetic */ void destroy_aroundBody6(SimpleHttpClient ajc$this, JoinPoint joinPoint) {
        IOUtils.closeQuietly((Closeable)ajc$this.requestExecutorService);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SimpleHttpClient.java", SimpleHttpClient.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "sendMessageToEndPoint", "org.jasig.cas.util.http.SimpleHttpClient", "org.jasig.cas.util.http.HttpMessage", "message", "", "boolean"), 93);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isValidEndPoint", "org.jasig.cas.util.http.SimpleHttpClient", "java.lang.String", "url", "", "boolean"), 122);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isValidEndPoint", "org.jasig.cas.util.http.SimpleHttpClient", "java.net.URL", "url", "", "boolean"), 132);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroy", "org.jasig.cas.util.http.SimpleHttpClient", "", "", "java.lang.Exception", "void"), 169);
    }
}

