/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.view.AbstractView;

public abstract class AbstractCasView
extends AbstractView {
    protected boolean successResponse;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected final Assertion getAssertionFrom(Map<String, Object> model) {
        return (Assertion)model.get("assertion");
    }

    protected final String getProxyGrantingTicketId(Map<String, Object> model) {
        return (String)model.get("proxyGrantingTicket");
    }

    protected final Authentication getPrimaryAuthenticationFrom(Map<String, Object> model) {
        return this.getAssertionFrom(model).getPrimaryAuthentication();
    }

    protected final String getAuthenticationAttribute(Map<String, Object> model, String attributeName) {
        Authentication authn = this.getPrimaryAuthenticationFrom(model);
        return (String)authn.getAttributes().get(attributeName);
    }

    protected final Principal getPrincipal(Map<String, Object> model) {
        return this.getPrimaryAuthenticationFrom(model).getPrincipal();
    }

    protected final Map<String, Object> getPrincipalAttributesAsMultiValuedAttributes(Map<String, Object> model) {
        return this.convertAttributeValuesToMultiValuedObjects(this.getPrincipal(model).getAttributes());
    }

    protected final Map<String, Object> getAuthenticationAttributesAsMultiValuedAttributes(Map<String, Object> model) {
        return this.convertAttributeValuesToMultiValuedObjects(this.getPrimaryAuthenticationFrom(model).getAttributes());
    }

    protected final boolean isRememberMeAuthentication(Map<String, Object> model) {
        Map<String, Object> authnAttributes = this.getAuthenticationAttributesAsMultiValuedAttributes(model);
        Collection authnMethod = (Collection)authnAttributes.get("org.jasig.cas.authentication.principal.REMEMBER_ME");
        return authnMethod != null && authnMethod.contains(Boolean.TRUE) && this.isAssertionBackedByNewLogin(model);
    }

    protected final boolean isAssertionBackedByNewLogin(Map<String, Object> model) {
        return this.getAssertionFrom(model).isFromNewLogin();
    }

    private Map<String, Object> convertAttributeValuesToMultiValuedObjects(Map<String, Object> attributes) {
        HashMap<String, Object> attributesToReturn = new HashMap<String, Object>();
        Set<Map.Entry<String, Object>> entries = attributes.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            Object value = entry.getValue();
            if (value instanceof Collection || value instanceof Map || value instanceof Object[] || value instanceof Iterator || value instanceof Enumeration) {
                attributesToReturn.put(entry.getKey(), value);
                continue;
            }
            attributesToReturn.put(entry.getKey(), Collections.singleton(value));
        }
        return attributesToReturn;
    }

    protected final Date getAuthenticationDate(Map<String, Object> model) {
        return this.getPrimaryAuthenticationFrom(model).getAuthenticationDate();
    }

    protected final Service getServiceFrom(Map<String, Object> model) {
        return (Service)model.get("service");
    }

    protected final Collection<Authentication> getChainedAuthentications(Map<String, Object> model) {
        ArrayList<Authentication> chainedAuthenticationsToReturn = new ArrayList<Authentication>();
        Assertion assertion = this.getAssertionFrom(model);
        List chainedAuthentications = assertion.getChainedAuthentications();
        int numberAuthenticationsExceptPrimary = chainedAuthentications.size() - 1;
        for (int i = 0; i < numberAuthenticationsExceptPrimary; ++i) {
            chainedAuthenticationsToReturn.add((Authentication)chainedAuthentications.get(i));
        }
        return chainedAuthenticationsToReturn;
    }

    protected final void putIntoModel(Map<String, Object> model, String key, Object value) {
        model.put(key, value);
    }

    protected final void putAllIntoModel(Map<String, Object> model, Map<String, Object> values) {
        model.putAll(values);
    }

    public final void setSuccessResponse(boolean successResponse) {
        this.successResponse = successResponse;
    }
}

