/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.principal.Principal;
import org.joda.time.DateTime;
import org.springframework.util.Assert;

public final class ImmutableAuthentication
implements Authentication {
    private static final long serialVersionUID = 3206127526058061391L;
    private final long authenticationDate;
    private final List<CredentialMetaData> credentials;
    private final Principal principal;
    private final Map<String, Object> attributes;
    private final Map<String, HandlerResult> successes;
    private final Map<String, Class<? extends Exception>> failures;

    private ImmutableAuthentication() {
        this.authenticationDate = 0L;
        this.credentials = null;
        this.principal = null;
        this.attributes = null;
        this.successes = null;
        this.failures = null;
    }

    public ImmutableAuthentication(DateTime date, List<CredentialMetaData> credentials, Principal principal, Map<String, Object> attributes, Map<String, HandlerResult> successes, Map<String, Class<? extends Exception>> failures) {
        Assert.notNull((Object)date, (String)"Date cannot be null");
        Assert.notNull(credentials, (String)"Credential cannot be null");
        Assert.notNull((Object)principal, (String)"Principal cannot be null");
        Assert.notNull(successes, (String)"Successes cannot be null");
        Assert.notEmpty(credentials, (String)"Credential cannot be empty");
        Assert.notEmpty(successes, (String)"Successes cannot be empty");
        this.authenticationDate = date.toDate().getTime();
        this.credentials = credentials;
        this.principal = principal;
        this.attributes = attributes.isEmpty() ? null : attributes;
        this.successes = successes;
        this.failures = failures.isEmpty() ? null : failures;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Date getAuthenticationDate() {
        return new ImmutableDate(this.authenticationDate);
    }

    public Map<String, Object> getAttributes() {
        return ImmutableAuthentication.wrap(this.attributes);
    }

    public List<CredentialMetaData> getCredentials() {
        return Collections.unmodifiableList(this.credentials);
    }

    public Map<String, HandlerResult> getSuccesses() {
        return Collections.unmodifiableMap(this.successes);
    }

    public Map<String, Class<? extends Exception>> getFailures() {
        return ImmutableAuthentication.wrap(this.failures);
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(97, 31);
        builder.append((Object)this.principal);
        builder.append(this.authenticationDate);
        builder.append(this.attributes);
        builder.append(this.credentials);
        builder.append(this.successes);
        builder.append(this.failures);
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Authentication)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Authentication other = (Authentication)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.principal, (Object)other.getPrincipal());
        builder.append(this.credentials, (Object)other.getCredentials());
        builder.append(this.successes, (Object)other.getSuccesses());
        builder.append(this.authenticationDate, other.getAuthenticationDate().getTime());
        builder.append(ImmutableAuthentication.wrap(this.attributes), (Object)other.getAttributes());
        builder.append(ImmutableAuthentication.wrap(this.failures), (Object)other.getFailures());
        return builder.isEquals();
    }

    private static <K, V> Map<K, V> wrap(Map<K, V> source) {
        if (source != null) {
            return Collections.unmodifiableMap(source);
        }
        return Collections.emptyMap();
    }

    private static final class ImmutableDate
    extends Date {
        private static final long serialVersionUID = 6275827030191703183L;

        private ImmutableDate() {
        }

        public ImmutableDate(long instant) {
            super(instant);
        }

        @Override
        public void setYear(int year) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDate(int date) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setHours(int hours) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMinutes(int minutes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSeconds(int seconds) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setTime(long time) {
            throw new UnsupportedOperationException();
        }
    }
}

