/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalAttributesRepository;
import org.jasig.cas.util.ApplicationContextProvider;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.merger.IAttributeMerger;
import org.jasig.services.persondir.support.merger.MultivaluedAttributeMerger;
import org.jasig.services.persondir.support.merger.NoncollidingAttributeAdder;
import org.jasig.services.persondir.support.merger.ReplacingAttributeAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public final class CachingPrincipalAttributesRepository
implements PrincipalAttributesRepository,
Closeable {
    private static final long serialVersionUID = 6350244643948535906L;
    private static final TimeUnit DEFAULT_CACHE_EXPIRATION_UNIT = TimeUnit.HOURS;
    private static final long DEFAULT_CACHE_EXPIRATION_DURATION = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingPrincipalAttributesRepository.class);
    private transient Cache<String, Map<String, Object>> cache;
    private final String cacheName = this.getClass().getSimpleName().concat(UUID.randomUUID().toString());
    private Duration duration;
    private transient IPersonAttributeDao attributeRepository;
    private MergingStrategy mergingStrategy;

    private CachingPrincipalAttributesRepository() {
        this(2L);
    }

    public CachingPrincipalAttributesRepository(long expiryDuration) {
        this(DEFAULT_CACHE_EXPIRATION_UNIT, expiryDuration);
    }

    public CachingPrincipalAttributesRepository(TimeUnit timeUnit, long expiryDuration) {
        this(new Duration(timeUnit, expiryDuration));
    }

    @JsonCreator
    public CachingPrincipalAttributesRepository(@JsonProperty(value="duration") Duration duration) {
        this(CachingPrincipalAttributesRepository.createCacheConfiguration(duration));
        this.duration = duration;
    }

    private CachingPrincipalAttributesRepository(MutableConfiguration<String, Map<String, Object>> config) {
        this(config, Caching.getCachingProvider().getCacheManager());
    }

    private CachingPrincipalAttributesRepository(MutableConfiguration<String, Map<String, Object>> config, String cacheProviderFullClassName) {
        this(config, Caching.getCachingProvider((String)cacheProviderFullClassName).getCacheManager());
    }

    private CachingPrincipalAttributesRepository(MutableConfiguration<String, Map<String, Object>> config, CacheManager manager) {
        this.cache = manager.createCache(this.cacheName, config);
    }

    public Duration getDuration() {
        return this.duration;
    }

    @JsonIgnore
    public MutableConfiguration<String, Map<String, Object>> getConfiguration() {
        return (MutableConfiguration)this.cache.getConfiguration(MutableConfiguration.class);
    }

    public void setMergingStrategy(MergingStrategy mergingStrategy) {
        this.mergingStrategy = mergingStrategy;
    }

    public IPersonAttributeDao getAttributeRepository() {
        return this.attributeRepository;
    }

    public void setAttributeRepository(IPersonAttributeDao attributeRepository) {
        this.attributeRepository = attributeRepository;
    }

    public MergingStrategy getMergingStrategy() {
        return this.mergingStrategy;
    }

    protected static MutableConfiguration<String, Map<String, Object>> createCacheConfiguration(Duration expiryDuration) {
        MutableConfiguration config = new MutableConfiguration();
        config.setStatisticsEnabled(true);
        config.setManagementEnabled(true);
        config.setStoreByValue(true);
        config.setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)expiryDuration));
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPrincipalAttributesIntoCache(String id, Map<String, Object> attributes) {
        Cache<String, Map<String, Object>> cache = this.cache;
        synchronized (cache) {
            if (attributes.isEmpty()) {
                this.cache.remove((Object)id);
                LOGGER.debug("No attributes are provided, so removed principal id [{}] from the cache", (Object)id);
            } else {
                this.cache.put((Object)id, attributes);
                LOGGER.debug("Cached [{}] attributes for the principal id [{}]", (Object)attributes.size(), (Object)id);
            }
        }
    }

    public Map<String, Object> getAttributes(Principal p) {
        Map cachedAttributes = (Map)this.cache.get((Object)p.getId());
        if (cachedAttributes != null) {
            LOGGER.debug("Found [{}] cached attributes for principal [{}]", (Object)cachedAttributes.size(), (Object)p.getId());
            return cachedAttributes;
        }
        Map<String, List<Object>> sourceAttributes = this.retrievePersonAttributesToPrincipalAttributes(p.getId());
        LOGGER.debug("Found [{}] attributes for principal [{}] from the attribute repository.", (Object)sourceAttributes.size(), (Object)p.getId());
        if (this.mergingStrategy == null || this.mergingStrategy.getAttributeMerger() == null) {
            LOGGER.debug("No merging strategy found, so attributes retrieved from the repository will be used instead.");
            Map<String, Object> finalAttributes = this.convertPersonAttributesToPrincipalAttributes(sourceAttributes);
            this.addPrincipalAttributesIntoCache(p.getId(), finalAttributes);
            return finalAttributes;
        }
        Map<String, List<Object>> principalAttributes = this.convertPrincipalAttributesToPersonAttributes(p);
        LOGGER.debug("Merging current principal attributes with that of the repository via strategy [{}]", (Object)((Object)((Object)this.mergingStrategy)).getClass().getSimpleName());
        Map mergedAttributes = this.mergingStrategy.getAttributeMerger().mergeAttributes(principalAttributes, sourceAttributes);
        Map<String, Object> finalAttributes = this.convertPersonAttributesToPrincipalAttributes(mergedAttributes);
        this.addPrincipalAttributesIntoCache(p.getId(), finalAttributes);
        return finalAttributes;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public void removePrincipalFromCache(Principal p) {
        this.cache.remove((Object)p.getId());
    }

    private Map<String, List<Object>> convertPrincipalAttributesToPersonAttributes(Principal p) {
        HashMap<String, List<Object>> convertedAttributes = new HashMap<String, List<Object>>(p.getAttributes().size());
        Map principalAttributes = p.getAttributes();
        for (Map.Entry entry : principalAttributes.entrySet()) {
            Object values = entry.getValue();
            String key = (String)entry.getKey();
            if (values instanceof List) {
                convertedAttributes.put(key, (List)values);
                continue;
            }
            convertedAttributes.put(key, Collections.singletonList(values));
        }
        return convertedAttributes;
    }

    private Map<String, Object> convertPersonAttributesToPrincipalAttributes(Map<String, List<Object>> attributes) {
        HashMap<String, Object> convertedAttributes = new HashMap<String, Object>();
        for (Map.Entry<String, List<Object>> entry : attributes.entrySet()) {
            List<Object> values = entry.getValue();
            convertedAttributes.put(entry.getKey(), values.size() == 1 ? values.get(0) : values);
        }
        return convertedAttributes;
    }

    private Map<String, List<Object>> retrievePersonAttributesToPrincipalAttributes(String id) {
        IPersonAttributes attrs;
        if (this.attributeRepository == null) {
            ApplicationContext context = ApplicationContextProvider.getApplicationContext();
            IPersonAttributeDao attributeRepository = (IPersonAttributeDao)context.getBean("attributeRepository", IPersonAttributeDao.class);
            attrs = attributeRepository.getPerson(id);
        } else {
            attrs = this.attributeRepository.getPerson(id);
        }
        if (attrs == null) {
            LOGGER.debug("Could not find principal [{}] in the repository so no attributes are returned.", (Object)id);
            return Collections.emptyMap();
        }
        Map attributes = attrs.getAttributes();
        if (attributes == null) {
            LOGGER.debug("Principal [{}] has no attributes and so none are returned.", (Object)id);
            return Collections.emptyMap();
        }
        return attributes;
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        this.cache.close();
        this.cache.getCacheManager().close();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cache", this.cache).append("cacheName", (Object)this.cacheName).append("durationTimeUnit", (Object)this.duration.getTimeUnit()).append("durationAmount", this.duration.getDurationAmount()).append("mergingStrategy", (Object)this.mergingStrategy).toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        CachingPrincipalAttributesRepository rhs = (CachingPrincipalAttributesRepository)obj;
        EqualsBuilder builder = new EqualsBuilder();
        return builder.append((Object)this.duration, (Object)rhs.duration).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 133).append((Object)this.duration).toHashCode();
    }

    public static enum MergingStrategy {
        REPLACE,
        ADD,
        NONE,
        MULTIVALUED;


        public IAttributeMerger getAttributeMerger() {
            String name = this.name().toUpperCase();
            switch (name.toUpperCase()) {
                case "REPLACE": {
                    return new ReplacingAttributeAdder();
                }
                case "ADD": {
                    return new NoncollidingAttributeAdder();
                }
                case "MULTIVALUED": {
                    return new MultivaluedAttributeMerger();
                }
            }
            return null;
        }
    }
}

