/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.Lob;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jasig.cas.services.AttributeReleasePolicy;
import org.jasig.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.jasig.cas.services.DefaultRegisteredServiceUsernameProvider;
import org.jasig.cas.services.LogoutType;
import org.jasig.cas.services.RefuseRegisteredServiceProxyPolicy;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceAccessStrategy;
import org.jasig.cas.services.RegisteredServiceProxyPolicy;
import org.jasig.cas.services.RegisteredServicePublicKey;
import org.jasig.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.jasig.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Inheritance
@DiscriminatorColumn(name="expression_type", length=15, discriminatorType=DiscriminatorType.STRING, columnDefinition="VARCHAR(15) DEFAULT 'ant'")
@Table(name="RegisteredServiceImpl")
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public abstract class AbstractRegisteredService
implements RegisteredService,
Comparable<RegisteredService> {
    private static final long serialVersionUID = 7645279151115635245L;
    @Transient
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Column(length=255, updatable=true, insertable=true, nullable=false)
    protected String serviceId;
    @Column(length=255, updatable=true, insertable=true, nullable=false)
    private String name;
    @Column(length=255, updatable=true, insertable=true, nullable=true)
    private String theme;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id = -9223372036854775807L;
    @Column(length=255, updatable=true, insertable=true, nullable=false)
    private String description;
    @Lob
    @Column(name="proxy_policy", nullable=true)
    private RegisteredServiceProxyPolicy proxyPolicy = new RefuseRegisteredServiceProxyPolicy();
    @Column(name="evaluation_order", nullable=false)
    private int evaluationOrder;
    @Lob
    @Column(name="username_attr", nullable=true)
    private RegisteredServiceUsernameAttributeProvider usernameAttributeProvider = new DefaultRegisteredServiceUsernameProvider();
    @Column(name="logout_type", nullable=true)
    private LogoutType logoutType = LogoutType.BACK_CHANNEL;
    @Lob
    @Column(name="required_handlers")
    private HashSet<String> requiredHandlers = new HashSet();
    @Lob
    @Column(name="attribute_release", nullable=true)
    private AttributeReleasePolicy attributeReleasePolicy = new ReturnAllowedAttributeReleasePolicy();
    @Column(name="logo")
    private URL logo;
    @Column(name="logout_url")
    private URL logoutUrl;
    @Lob
    @Column(name="access_strategy", nullable=true)
    private RegisteredServiceAccessStrategy accessStrategy = new DefaultRegisteredServiceAccessStrategy();
    @Lob
    @Column(name="public_key", nullable=true)
    private RegisteredServicePublicKey publicKey;

    public long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getName() {
        return this.name;
    }

    public String getTheme() {
        return this.theme;
    }

    public RegisteredServiceProxyPolicy getProxyPolicy() {
        return this.proxyPolicy;
    }

    public RegisteredServiceAccessStrategy getAccessStrategy() {
        return this.accessStrategy;
    }

    public URL getLogoutUrl() {
        return this.logoutUrl;
    }

    @PostLoad
    public final void postLoad() {
        if (this.proxyPolicy == null) {
            this.proxyPolicy = new RefuseRegisteredServiceProxyPolicy();
        }
        if (this.usernameAttributeProvider == null) {
            this.usernameAttributeProvider = new DefaultRegisteredServiceUsernameProvider();
        }
        if (this.logoutType == null) {
            this.logoutType = LogoutType.BACK_CHANNEL;
        }
        if (this.requiredHandlers == null) {
            this.requiredHandlers = new HashSet();
        }
        if (this.accessStrategy == null) {
            this.accessStrategy = new DefaultRegisteredServiceAccessStrategy();
        }
        if (this.attributeReleasePolicy == null) {
            this.attributeReleasePolicy = new ReturnAllowedAttributeReleasePolicy();
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractRegisteredService)) {
            return false;
        }
        AbstractRegisteredService that = (AbstractRegisteredService)o;
        EqualsBuilder builder = new EqualsBuilder();
        return builder.append((Object)this.proxyPolicy, (Object)that.proxyPolicy).append(this.evaluationOrder, that.evaluationOrder).append((Object)this.description, (Object)that.description).append((Object)this.name, (Object)that.name).append((Object)this.serviceId, (Object)that.serviceId).append((Object)this.theme, (Object)that.theme).append((Object)this.usernameAttributeProvider, (Object)that.usernameAttributeProvider).append((Object)this.logoutType, (Object)that.logoutType).append((Object)this.attributeReleasePolicy, (Object)that.attributeReleasePolicy).append((Object)this.accessStrategy, (Object)that.accessStrategy).append((Object)this.logo, (Object)that.logo).append((Object)this.publicKey, (Object)that.publicKey).append((Object)this.logoutUrl, (Object)that.logoutUrl).append(this.requiredHandlers, that.requiredHandlers).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 31).append((Object)this.description).append((Object)this.serviceId).append((Object)this.name).append((Object)this.theme).append(this.evaluationOrder).append((Object)this.usernameAttributeProvider).append((Object)this.accessStrategy).append((Object)this.logoutType).append((Object)this.attributeReleasePolicy).append((Object)this.accessStrategy).append((Object)this.logo).append((Object)this.publicKey).append((Object)this.logoutUrl).append(this.requiredHandlers).toHashCode();
    }

    public void setProxyPolicy(RegisteredServiceProxyPolicy policy) {
        this.proxyPolicy = policy;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public abstract void setServiceId(String var1);

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public void setEvaluationOrder(int evaluationOrder) {
        this.evaluationOrder = evaluationOrder;
    }

    public int getEvaluationOrder() {
        return this.evaluationOrder;
    }

    public RegisteredServiceUsernameAttributeProvider getUsernameAttributeProvider() {
        return this.usernameAttributeProvider;
    }

    public void setAccessStrategy(RegisteredServiceAccessStrategy accessStrategy) {
        this.accessStrategy = accessStrategy;
    }

    public void setLogoutUrl(URL logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public void setUsernameAttributeProvider(RegisteredServiceUsernameAttributeProvider usernameProvider) {
        this.usernameAttributeProvider = usernameProvider;
    }

    public final LogoutType getLogoutType() {
        return this.logoutType;
    }

    public final void setLogoutType(LogoutType logoutType) {
        this.logoutType = logoutType;
    }

    public final RegisteredService clone() {
        AbstractRegisteredService clone = this.newInstance();
        clone.copyFrom(this);
        return clone;
    }

    public void copyFrom(RegisteredService source) {
        this.setId(source.getId());
        this.setProxyPolicy(source.getProxyPolicy());
        this.setDescription(source.getDescription());
        this.setName(source.getName());
        this.setServiceId(source.getServiceId());
        this.setTheme(source.getTheme());
        this.setEvaluationOrder(source.getEvaluationOrder());
        this.setUsernameAttributeProvider(source.getUsernameAttributeProvider());
        this.setLogoutType(source.getLogoutType());
        this.setAttributeReleasePolicy(source.getAttributeReleasePolicy());
        this.setAccessStrategy(source.getAccessStrategy());
        this.setLogo(source.getLogo());
        this.setPublicKey(source.getPublicKey());
        this.setLogoutUrl(source.getLogoutUrl());
        this.setPublicKey(source.getPublicKey());
        this.setRequiredHandlers(source.getRequiredHandlers());
    }

    @Override
    public int compareTo(RegisteredService other) {
        return new CompareToBuilder().append(this.getEvaluationOrder(), other.getEvaluationOrder()).append((Object)this.getName().toLowerCase(), (Object)other.getName().toLowerCase()).append((Object)this.getServiceId(), (Object)other.getServiceId()).toComparison();
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(null, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("id", this.id);
        toStringBuilder.append("name", (Object)this.name);
        toStringBuilder.append("description", (Object)this.description);
        toStringBuilder.append("serviceId", (Object)this.serviceId);
        toStringBuilder.append("usernameAttributeProvider", (Object)this.usernameAttributeProvider);
        toStringBuilder.append("theme", (Object)this.theme);
        toStringBuilder.append("evaluationOrder", this.evaluationOrder);
        toStringBuilder.append("logoutType", (Object)this.logoutType);
        toStringBuilder.append("attributeReleasePolicy", (Object)this.attributeReleasePolicy);
        toStringBuilder.append("accessStrategy", (Object)this.accessStrategy);
        toStringBuilder.append("publicKey", (Object)this.publicKey);
        toStringBuilder.append("proxyPolicy", (Object)this.proxyPolicy);
        toStringBuilder.append("logo", (Object)this.logo);
        toStringBuilder.append("logoutUrl", (Object)this.logoutUrl);
        toStringBuilder.append("requiredHandlers", this.requiredHandlers);
        return toStringBuilder.toString();
    }

    protected abstract AbstractRegisteredService newInstance();

    public Set<String> getRequiredHandlers() {
        if (this.requiredHandlers == null) {
            this.requiredHandlers = new HashSet();
        }
        return this.requiredHandlers;
    }

    public void setRequiredHandlers(Set<String> handlers) {
        this.getRequiredHandlers().clear();
        if (handlers == null) {
            return;
        }
        for (String handler : handlers) {
            this.getRequiredHandlers().add(handler);
        }
    }

    public final void setAttributeReleasePolicy(AttributeReleasePolicy policy) {
        this.attributeReleasePolicy = policy;
    }

    public final AttributeReleasePolicy getAttributeReleasePolicy() {
        return this.attributeReleasePolicy;
    }

    public URL getLogo() {
        return this.logo;
    }

    public void setLogo(URL logo) {
        this.logo = logo;
    }

    public RegisteredServicePublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(@NotNull RegisteredServicePublicKey publicKey) {
        this.publicKey = publicKey;
    }
}

