/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.services.AbstractRegisteredService;
import org.jasig.cas.services.JsonServiceRegistryConfigWatcher;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ReloadableServicesManager;
import org.jasig.cas.services.ServiceRegistryDao;
import org.jasig.cas.util.JsonSerializer;
import org.jasig.cas.util.LockedOutputStream;
import org.jasig.cas.util.services.RegisteredServiceJsonSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class JsonServiceRegistryDao
implements ServiceRegistryDao,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonServiceRegistryDao.class);
    private static final String FILE_EXTENSION = "json";
    private Map<Long, RegisteredService> serviceMap = new ConcurrentHashMap<Long, RegisteredService>();
    private final Path serviceRegistryDirectory;
    private final JsonSerializer<RegisteredService> registeredServiceJsonSerializer;
    private ApplicationContext applicationContext;

    public JsonServiceRegistryDao(Path configDirectory, JsonSerializer<RegisteredService> registeredServiceJsonSerializer) {
        this.serviceRegistryDirectory = configDirectory;
        Assert.isTrue((boolean)this.serviceRegistryDirectory.toFile().exists(), (String)(this.serviceRegistryDirectory + " does not exist"));
        Assert.isTrue((boolean)this.serviceRegistryDirectory.toFile().isDirectory(), (String)(this.serviceRegistryDirectory + " is not a directory"));
        this.registeredServiceJsonSerializer = registeredServiceJsonSerializer;
        this.initializeWatchServiceThread();
    }

    public JsonServiceRegistryDao(Path configDirectory) {
        this(configDirectory, new RegisteredServiceJsonSerializer());
    }

    public JsonServiceRegistryDao(File configDirectory) throws IOException {
        this(Paths.get(configDirectory.getCanonicalPath(), new String[0]));
    }

    public final RegisteredService save(RegisteredService service) {
        if (service.getId() == -9223372036854775807L && service instanceof AbstractRegisteredService) {
            LOGGER.debug("Service id not set. Calculating id based on system time...");
            ((AbstractRegisteredService)service).setId(System.nanoTime());
        }
        File f = this.makeFile(service);
        try (LockedOutputStream out = new LockedOutputStream(new FileOutputStream(f));){
            this.registeredServiceJsonSerializer.toJson(out, service);
            if (this.serviceMap.containsKey(service.getId())) {
                LOGGER.debug("Found existing service definition by id [{}]. Saving...", (Object)service.getId());
            }
            this.serviceMap.put(service.getId(), service);
            LOGGER.debug("Saved service to [{}]", (Object)f.getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException("IO error opening file stream.", e);
        }
        return this.findServiceById(service.getId());
    }

    public final synchronized boolean delete(RegisteredService service) {
        try {
            File f = this.makeFile(service);
            boolean result = f.delete();
            if (!result) {
                LOGGER.warn("Failed to delete service definition file [{}]", (Object)f.getCanonicalPath());
            } else {
                this.serviceMap.remove(service.getId());
                LOGGER.debug("Successfully deleted service definition file [{}]", (Object)f.getCanonicalPath());
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final synchronized List<RegisteredService> load() {
        ConcurrentHashMap<Long, RegisteredService> temp = new ConcurrentHashMap<Long, RegisteredService>();
        int errorCount = 0;
        Collection c = FileUtils.listFiles((File)this.serviceRegistryDirectory.toFile(), (String[])new String[]{FILE_EXTENSION}, (boolean)true);
        for (File file : c) {
            if (file.length() <= 0L) continue;
            RegisteredService service = this.loadRegisteredServiceFromFile(file);
            if (service == null) {
                ++errorCount;
                continue;
            }
            if (temp.containsKey(service.getId())) {
                LOGGER.warn("Found a service definition [{}] with a duplicate id [{}]. This will overwrite previous service definitions and is likely a configuration problem. Make sure all services have a unique id and try again.", (Object)service.getServiceId(), (Object)service.getId());
            }
            temp.put(service.getId(), service);
        }
        if (errorCount == 0) {
            this.serviceMap = temp;
        }
        return new ArrayList<RegisteredService>(this.serviceMap.values());
    }

    public final RegisteredService findServiceById(long id) {
        return this.serviceMap.get(id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    RegisteredService loadRegisteredServiceFromFile(File file) {
        if (!file.canRead()) {
            LOGGER.warn("[{}] is not readable. Check file permissions", (Object)file.getName());
            return null;
        }
        if (!file.exists()) {
            LOGGER.warn("[{}] is not found at the path specified", (Object)file.getName());
            return null;
        }
        if (file.length() == 0L) {
            LOGGER.debug("[{}] appears to be empty so no service definition will be loaded", (Object)file.getName());
            return null;
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            RegisteredService registeredService = this.registeredServiceJsonSerializer.fromJson(in);
            return registeredService;
        }
        catch (Exception e) {
            LOGGER.error("Error reading configuration file " + file.getName(), (Throwable)e);
            return null;
        }
    }

    void updateRegisteredService(RegisteredService service) {
        this.serviceMap.put(service.getId(), service);
    }

    Path getServiceRegistryDirectory() {
        return this.serviceRegistryDirectory;
    }

    protected File makeFile(RegisteredService service) {
        String fileName = StringUtils.remove((String)(service.getName() + '-' + service.getId() + '.' + FILE_EXTENSION), (String)" ");
        try {
            File svcFile = new File(this.serviceRegistryDirectory.toFile(), fileName);
            LOGGER.debug("Using [{}] as the service definition file", (Object)svcFile.getCanonicalPath());
            return svcFile;
        }
        catch (IOException e) {
            LOGGER.warn("Service file name {} is invalid; Examine for illegal characters in the name.", (Object)fileName);
            throw new IllegalArgumentException(e);
        }
    }

    private void initializeWatchServiceThread() {
        Thread thread = new Thread(new JsonServiceRegistryConfigWatcher(this));
        thread.start();
    }

    void refreshServicesManager() {
        if (this.applicationContext == null) {
            LOGGER.debug("Application context has failed to initializeService definition may not take immediate effect, which suggests a configuration problem");
            return;
        }
        ReloadableServicesManager manager = (ReloadableServicesManager)this.applicationContext.getBean(ReloadableServicesManager.class);
        if (manager != null) {
            manager.reload();
        } else {
            LOGGER.warn("Services manger could not be obtained from the application context. Service definition may not take immediate effect, which suggests a configuration problem");
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

