/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.io.Serializable;
import java.security.PublicKey;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jasig.cas.services.RegisteredServicePublicKey;
import org.jasig.cas.util.PublicKeyFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class RegisteredServicePublicKeyImpl
implements Serializable,
RegisteredServicePublicKey {
    private static final long serialVersionUID = -8497658523695695863L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String location;
    private String algorithm;
    private Class<PublicKeyFactoryBean> publicKeyFactoryBeanClass = PublicKeyFactoryBean.class;

    private RegisteredServicePublicKeyImpl() {
    }

    public RegisteredServicePublicKeyImpl(String location, String algorithm) {
        this.location = location;
        this.algorithm = algorithm;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setPublicKeyFactoryBeanClass(Class<PublicKeyFactoryBean> publicKeyFactoryBeanClass) {
        this.publicKeyFactoryBeanClass = publicKeyFactoryBeanClass;
    }

    public PublicKey createInstance() throws Exception {
        try {
            PublicKeyFactoryBean factory = this.publicKeyFactoryBeanClass.newInstance();
            if (this.location.startsWith("classpath:")) {
                factory.setLocation((Resource)new ClassPathResource(StringUtils.removeStart((String)this.location, (String)"classpath:")));
            } else {
                factory.setLocation((Resource)new FileSystemResource(this.location));
            }
            factory.setAlgorithm(this.algorithm);
            factory.setSingleton(false);
            return (PublicKey)factory.getObject();
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("location", (Object)this.location).append("algorithm", (Object)this.algorithm).toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RegisteredServicePublicKeyImpl rhs = (RegisteredServicePublicKeyImpl)obj;
        return new EqualsBuilder().append((Object)this.location, (Object)rhs.location).append((Object)this.algorithm, (Object)rhs.algorithm).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.location).append((Object)this.algorithm).toHashCode();
    }
}

