/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.support;

import java.util.concurrent.TimeUnit;
import org.jasig.cas.ticket.TicketState;
import org.jasig.cas.ticket.support.AbstractCasExpirationPolicy;
import org.springframework.util.Assert;

public final class MultiTimeUseOrTimeoutExpirationPolicy
extends AbstractCasExpirationPolicy {
    private static final long serialVersionUID = -5704993954986738308L;
    private final long timeToKillInMilliSeconds;
    private final int numberOfUses;

    private MultiTimeUseOrTimeoutExpirationPolicy() {
        this.timeToKillInMilliSeconds = 0L;
        this.numberOfUses = 0;
    }

    public MultiTimeUseOrTimeoutExpirationPolicy(int numberOfUses, long timeToKillInMilliSeconds) {
        this.timeToKillInMilliSeconds = timeToKillInMilliSeconds;
        this.numberOfUses = numberOfUses;
        Assert.isTrue((this.numberOfUses > 0 ? 1 : 0) != 0, (String)"numberOfUsers must be greater than 0.");
        Assert.isTrue((this.timeToKillInMilliSeconds > 0L ? 1 : 0) != 0, (String)"timeToKillInMilliseconds must be greater than 0.");
    }

    public MultiTimeUseOrTimeoutExpirationPolicy(int numberOfUses, long timeToKill, TimeUnit timeUnit) {
        this(numberOfUses, timeUnit.toMillis(timeToKill));
    }

    public boolean isExpired(TicketState ticketState) {
        return ticketState == null || ticketState.getCountOfUses() >= this.numberOfUses || System.currentTimeMillis() - ticketState.getLastTimeUsed() >= this.timeToKillInMilliSeconds;
    }
}

