/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.support;

import org.jasig.cas.ticket.TicketState;
import org.jasig.cas.ticket.support.AbstractCasExpirationPolicy;

public final class ThrottledUseAndTimeoutExpirationPolicy
extends AbstractCasExpirationPolicy {
    private static final long serialVersionUID = 205979491183779408L;
    private long timeToKillInMilliSeconds;
    private long timeInBetweenUsesInMilliSeconds;

    public void setTimeInBetweenUsesInMilliSeconds(long timeInBetweenUsesInMilliSeconds) {
        this.timeInBetweenUsesInMilliSeconds = timeInBetweenUsesInMilliSeconds;
    }

    public void setTimeToKillInMilliSeconds(long timeToKillInMilliSeconds) {
        this.timeToKillInMilliSeconds = timeToKillInMilliSeconds;
    }

    public boolean isExpired(TicketState ticketState) {
        long currentTimeInMillis = System.currentTimeMillis();
        long lastTimeTicketWasUsed = ticketState.getLastTimeUsed();
        if (ticketState.getCountOfUses() == 0 && currentTimeInMillis - lastTimeTicketWasUsed < this.timeToKillInMilliSeconds) {
            this.logger.debug("Ticket is not expired due to a count of zero and the time being less than the timeToKillInMilliseconds");
            return false;
        }
        if (currentTimeInMillis - lastTimeTicketWasUsed >= this.timeToKillInMilliSeconds) {
            this.logger.debug("Ticket is expired due to the time being greater than the timeToKillInMilliseconds");
            return true;
        }
        if (currentTimeInMillis - lastTimeTicketWasUsed <= this.timeInBetweenUsesInMilliSeconds) {
            this.logger.warn("Ticket is expired due to the time being less than the waiting period.");
            return true;
        }
        return false;
    }
}

