/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.security.Key;
import java.util.HashMap;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.util.CipherExecutor;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.keys.AesKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultCipherExecutor
implements CipherExecutor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String contentEncryptionAlgorithmIdentifier;
    private final String signingAlgorithm;
    private final Key secretKeyEncryptionKey;
    private final Key secretKeySigningKey;

    public DefaultCipherExecutor(String secretKeyEncryption, String secretKeySigning) {
        this(secretKeyEncryption, secretKeySigning, "A128CBC-HS256", "HS512");
    }

    public DefaultCipherExecutor(String secretKeyEncryption, String secretKeySigning, String contentEncryptionAlgorithmIdentifier, String signingAlgorithm) {
        this.secretKeyEncryptionKey = this.prepareJsonWebTokenKey(secretKeyEncryption);
        this.contentEncryptionAlgorithmIdentifier = contentEncryptionAlgorithmIdentifier;
        this.logger.debug("Initialized cipher encryption sequence via [{}]", (Object)contentEncryptionAlgorithmIdentifier);
        this.signingAlgorithm = signingAlgorithm;
        this.secretKeySigningKey = new AesKey(secretKeySigning.getBytes());
        this.logger.debug("Initialized cipher signing sequence via [{}]", (Object)signingAlgorithm);
    }

    @Override
    public String encode(String value) {
        String encoded = this.encryptValue(value);
        return this.signValue(encoded);
    }

    @Override
    public String decode(String value) {
        String encoded = this.verifySignature(value);
        if (StringUtils.isNotBlank((CharSequence)encoded)) {
            return this.decryptValue(encoded);
        }
        return null;
    }

    private Key prepareJsonWebTokenKey(String secret) {
        try {
            HashMap<String, String> keys = new HashMap<String, String>(2);
            keys.put("kty", "oct");
            keys.put("k", secret);
            JsonWebKey jwk = JsonWebKey.Factory.newJwk(keys);
            return jwk.getKey();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private String encryptValue(@NotNull String value) {
        try {
            JsonWebEncryption jwe = new JsonWebEncryption();
            jwe.setPayload(value);
            jwe.setAlgorithmHeaderValue("dir");
            jwe.setEncryptionMethodHeaderParameter(this.contentEncryptionAlgorithmIdentifier);
            jwe.setKey(this.secretKeyEncryptionKey);
            this.logger.debug("Encrypting via [{}]", (Object)this.contentEncryptionAlgorithmIdentifier);
            return jwe.getCompactSerialization();
        }
        catch (Exception e) {
            throw new RuntimeException("Ensure that you have installed JCE Unlimited Strength Jurisdiction Policy Files. " + e.getMessage(), e);
        }
    }

    private String decryptValue(@NotNull String value) {
        try {
            JsonWebEncryption jwe = new JsonWebEncryption();
            jwe.setKey(this.secretKeyEncryptionKey);
            jwe.setCompactSerialization(value);
            this.logger.debug("Decrypting value...");
            return jwe.getPayload();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String signValue(@NotNull String value) {
        try {
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(value);
            jws.setAlgorithmHeaderValue(this.signingAlgorithm);
            jws.setKey(this.secretKeySigningKey);
            return jws.getCompactSerialization();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String verifySignature(@NotNull String value) {
        try {
            JsonWebSignature jws = new JsonWebSignature();
            jws.setCompactSerialization(value);
            jws.setKey(this.secretKeySigningKey);
            boolean verified = jws.verifySignature();
            if (verified) {
                this.logger.debug("Signature successfully verified. Payload is [{}]", (Object)jws.getPayload());
                return jws.getPayload();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

