/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util.http;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.FutureRequestExecutionService;
import org.apache.http.impl.client.HttpRequestFutureTask;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jasig.cas.util.http.HttpClient;
import org.jasig.cas.util.http.HttpMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.Assert;

final class SimpleHttpClient
implements HttpClient,
Serializable,
DisposableBean {
    private static final long serialVersionUID = -4949380008568071855L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleHttpClient.class);
    private final List<Integer> acceptableCodes;
    private final CloseableHttpClient httpClient;
    private final FutureRequestExecutionService requestExecutorService;

    public SimpleHttpClient(List<Integer> acceptableCodes, CloseableHttpClient httpClient, FutureRequestExecutionService requestExecutorService) {
        this.acceptableCodes = ImmutableList.copyOf(acceptableCodes);
        this.httpClient = httpClient;
        this.requestExecutorService = requestExecutorService;
    }

    @Override
    public boolean sendMessageToEndPoint(HttpMessage message) {
        Assert.notNull((Object)this.httpClient);
        try {
            HttpPost request = new HttpPost(message.getUrl().toURI());
            request.addHeader("Content-Type", message.getContentType());
            StringEntity entity = new StringEntity(message.getMessage(), ContentType.create((String)message.getContentType()));
            request.setEntity((HttpEntity)entity);
            HttpRequestFutureTask task = this.requestExecutorService.execute((HttpUriRequest)request, (HttpContext)HttpClientContext.create(), (ResponseHandler)new BasicResponseHandler());
            if (message.isAsynchronous()) {
                return true;
            }
            return StringUtils.isNotBlank((CharSequence)((CharSequence)task.get()));
        }
        catch (RejectedExecutionException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isValidEndPoint(String url) {
        try {
            URL u = new URL(url);
            return this.isValidEndPoint(u);
        }
        catch (MalformedURLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValidEndPoint(URL url) {
        Assert.notNull((Object)this.httpClient);
        HttpEntity entity = null;
        try {
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet(url.toURI()));){
                int responseCode = response.getStatusLine().getStatusCode();
                for (int acceptableCode : this.acceptableCodes) {
                    if (responseCode != acceptableCode) continue;
                    LOGGER.debug("Response code from server matched {}.", (Object)responseCode);
                    boolean bl = true;
                    EntityUtils.consumeQuietly((HttpEntity)entity);
                    return bl;
                }
                LOGGER.debug("Response code did not match any of the acceptable response codes. Code returned was {}", (Object)responseCode);
                if (responseCode == 500) {
                    String value = response.getStatusLine().getReasonPhrase();
                    LOGGER.error("There was an error contacting the endpoint: {}; The error was:\n{}", (Object)url.toExternalForm(), (Object)value);
                }
                entity = response.getEntity();
            }
            EntityUtils.consumeQuietly((HttpEntity)entity);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            EntityUtils.consumeQuietly(entity);
        }
        return false;
    }

    public void destroy() throws Exception {
        IOUtils.closeQuietly((Closeable)this.requestExecutorService);
    }

    @Deprecated
    public void setExecutorService(@NotNull ExecutorService executorService) {
        LOGGER.warn("setExecutorService() is deprecated and has no effect. Consider using SimpleHttpClientFactoryBean instead.");
    }

    @Deprecated
    public void setAcceptableCodes(int[] acceptableCodes) {
        LOGGER.warn("setAcceptableCodes() is deprecated and has no effect. Consider using SimpleHttpClientFactoryBean instead.");
    }

    @Deprecated
    public void setConnectionTimeout(int connectionTimeout) {
        LOGGER.warn("setConnectionTimeout() is deprecated and has no effect. Consider using SimpleHttpClientFactoryBean instead.");
    }

    @Deprecated
    public void setReadTimeout(int readTimeout) {
        LOGGER.warn("setReadTimeout() is deprecated and has no effect. Consider using SimpleHttpClientFactoryBean instead.");
    }

    @Deprecated
    public void setFollowRedirects(boolean follow) {
        LOGGER.warn("setFollowRedirects() is deprecated and has no effect. Consider using SimpleHttpClientFactoryBean instead.");
    }

    @Deprecated
    public void setSSLSocketFactory(SSLSocketFactory factory) {
        LOGGER.warn("setSSLSocketFactory() is deprecated and has no effect. Consider using SimpleHttpClientFactoryBean instead.");
    }

    @Deprecated
    public void setHostnameVerifier(HostnameVerifier verifier) {
        LOGGER.warn("setHostnameVerifier() is deprecated and has no effect. Consider using SimpleHttpClientFactoryBean instead.");
    }
}

