/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ReloadableServicesManager;
import org.jasig.cas.services.ServiceRegistryDao;
import org.jasig.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultServicesManagerImpl
implements ReloadableServicesManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServicesManagerImpl.class);
    @NotNull
    private final ServiceRegistryDao serviceRegistryDao;
    private ConcurrentHashMap<Long, RegisteredService> services = new ConcurrentHashMap();

    public DefaultServicesManagerImpl(ServiceRegistryDao serviceRegistryDao) {
        this.serviceRegistryDao = serviceRegistryDao;
        this.load();
    }

    @Deprecated
    public DefaultServicesManagerImpl(ServiceRegistryDao serviceRegistryDao, List<String> defaultAttributes) {
        this(serviceRegistryDao);
        LOGGER.warn("This constructor is deprecated and will be removed in future CAS versions");
    }

    @Audit(action="DELETE_SERVICE", actionResolverName="DELETE_SERVICE_ACTION_RESOLVER", resourceResolverName="DELETE_SERVICE_RESOURCE_RESOLVER")
    public synchronized RegisteredService delete(long id) {
        RegisteredService r = this.findServiceBy(id);
        if (r == null) {
            return null;
        }
        this.serviceRegistryDao.delete(r);
        this.services.remove(id);
        return r;
    }

    public RegisteredService findServiceBy(Service service) {
        TreeSet<RegisteredService> c = this.convertToTreeSet();
        for (RegisteredService r : c) {
            if (!r.matches(service)) continue;
            return r;
        }
        return null;
    }

    public RegisteredService findServiceBy(long id) {
        RegisteredService r = this.services.get(id);
        try {
            return r == null ? null : r.clone();
        }
        catch (CloneNotSupportedException e) {
            return r;
        }
    }

    protected TreeSet<RegisteredService> convertToTreeSet() {
        return new TreeSet<RegisteredService>(this.services.values());
    }

    public Collection<RegisteredService> getAllServices() {
        return Collections.unmodifiableCollection(this.convertToTreeSet());
    }

    public boolean matchesExistingService(Service service) {
        return this.findServiceBy(service) != null;
    }

    @Audit(action="SAVE_SERVICE", actionResolverName="SAVE_SERVICE_ACTION_RESOLVER", resourceResolverName="SAVE_SERVICE_RESOURCE_RESOLVER")
    public synchronized RegisteredService save(RegisteredService registeredService) {
        RegisteredService r = this.serviceRegistryDao.save(registeredService);
        this.services.put(r.getId(), r);
        return r;
    }

    public void reload() {
        LOGGER.info("Reloading registered services.");
        this.load();
    }

    private void load() {
        ConcurrentHashMap<Long, RegisteredService> localServices = new ConcurrentHashMap<Long, RegisteredService>();
        for (RegisteredService r : this.serviceRegistryDao.load()) {
            LOGGER.debug("Adding registered service {}", (Object)r.getServiceId());
            localServices.put(r.getId(), r);
        }
        this.services = localServices;
        LOGGER.info("Loaded {} services.", (Object)this.services.size());
    }
}

