/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util.http;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpMessage.class);
    private static final boolean DEFAULT_ASYNCHRONOUS_CALLBACKS_ENABLED = true;
    private final URL url;
    private final String message;
    private final boolean asynchronous;
    private String contentType = "application/x-www-form-urlencoded";

    public HttpMessage(URL url, String message) {
        this(url, message, true);
    }

    public HttpMessage(URL url, String message, boolean async) {
        this.url = url;
        this.message = message;
        this.asynchronous = async;
    }

    protected boolean isAsynchronous() {
        return this.asynchronous;
    }

    protected final URL getUrl() {
        return this.url;
    }

    protected final String getMessage() {
        return this.formatOutputMessageInternal(this.message);
    }

    protected final String getContentType() {
        return this.contentType;
    }

    protected final void setContentType(String type) {
        this.contentType = type;
    }

    protected String formatOutputMessageInternal(String message) {
        try {
            return URLEncoder.encode(message, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return message;
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("url", (Object)this.url).append("message", (Object)this.message).append("asynchronous", this.asynchronous).append("contentType", (Object)this.contentType).toString();
    }
}

