/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.audit.spi;

import org.aspectj.lang.JoinPoint;
import org.jasig.cas.audit.spi.TicketOrCredentialPrincipalResolver;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.validation.Assertion;
import org.jasig.inspektr.common.spi.PrincipalResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertionAsReturnValuePrincipalResolver
implements PrincipalResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssertionAsReturnValuePrincipalResolver.class);
    private TicketOrCredentialPrincipalResolver delegate;

    public AssertionAsReturnValuePrincipalResolver(TicketOrCredentialPrincipalResolver delegate) {
        this.delegate = delegate;
    }

    public String resolveFrom(JoinPoint auditTarget, Object returnValue) {
        LOGGER.debug("Trying to see if target's return value is instance of [Assertion]...");
        if (returnValue instanceof Assertion) {
            LOGGER.debug("Assertion instance is found in the return value. Resolving principal id from associated Authentication...");
            Authentication authentication = ((Assertion)Assertion.class.cast(returnValue)).getPrimaryAuthentication();
            return this.delegate.getPrincipalIdProvider().getPrincipalIdFrom(authentication);
        }
        LOGGER.debug("Resolving principal from the delegate principal resolver: [{}]...", (Object)this.delegate);
        String principalIdResolvedByDelagate = this.delegate.resolveFrom(auditTarget, returnValue);
        if ("audit:unknown".equals(principalIdResolvedByDelagate)) {
            LOGGER.debug("Meaningful principal id could not be resolved by [{}]. Returning [{}]...", (Object)this, (Object)principalIdResolvedByDelagate);
        }
        return principalIdResolvedByDelagate;
    }

    public String resolveFrom(JoinPoint auditTarget, Exception exception) {
        return this.delegate.resolveFrom(auditTarget, exception);
    }

    public String resolve() {
        return this.delegate.resolve();
    }
}

