/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import javax.validation.constraints.NotNull;
import org.jasig.cas.monitor.Monitor;
import org.jasig.cas.monitor.SessionStatus;
import org.jasig.cas.monitor.StatusCode;
import org.jasig.cas.monitor.TicketRegistryState;

public class SessionMonitor
implements Monitor<SessionStatus> {
    @NotNull
    private TicketRegistryState registryState;
    private int sessionCountWarnThreshold = -1;
    private int serviceTicketCountWarnThreshold = -1;

    public void setTicketRegistry(TicketRegistryState state) {
        this.registryState = state;
    }

    public void setSessionCountWarnThreshold(int threshold) {
        this.sessionCountWarnThreshold = threshold;
    }

    public void setServiceTicketCountWarnThreshold(int threshold) {
        this.serviceTicketCountWarnThreshold = threshold;
    }

    public String getName() {
        return SessionMonitor.class.getSimpleName();
    }

    public SessionStatus observe() {
        try {
            int sessionCount = this.registryState.sessionCount();
            int ticketCount = this.registryState.serviceTicketCount();
            if (sessionCount == Integer.MIN_VALUE || ticketCount == Integer.MIN_VALUE) {
                return new SessionStatus(StatusCode.UNKNOWN, String.format("Ticket registry %s reports unknown session and/or ticket counts.", this.registryState.getClass().getName()), sessionCount, ticketCount);
            }
            StringBuilder msg = new StringBuilder();
            StatusCode code = StatusCode.OK;
            if (this.sessionCountWarnThreshold > -1 && sessionCount > this.sessionCountWarnThreshold) {
                code = StatusCode.WARN;
                msg.append(String.format("Session count (%s) is above threshold %s. ", sessionCount, this.sessionCountWarnThreshold));
            } else {
                msg.append(sessionCount).append(" sessions. ");
            }
            if (this.serviceTicketCountWarnThreshold > -1 && ticketCount > this.serviceTicketCountWarnThreshold) {
                code = StatusCode.WARN;
                msg.append(String.format("Service ticket count (%s) is above threshold %s.", ticketCount, this.serviceTicketCountWarnThreshold));
            } else {
                msg.append(ticketCount).append(" service tickets.");
            }
            return new SessionStatus(code, msg.toString(), sessionCount, ticketCount);
        }
        catch (Exception e) {
            return new SessionStatus(StatusCode.ERROR, e.getMessage());
        }
    }
}

