/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.support;

import java.util.concurrent.TimeUnit;
import org.jasig.cas.ticket.TicketState;
import org.jasig.cas.ticket.support.AbstractCasExpirationPolicy;

public final class TimeoutExpirationPolicy
extends AbstractCasExpirationPolicy {
    private static final long serialVersionUID = -7636642464326939536L;
    private final long timeToKillInMilliSeconds;

    private TimeoutExpirationPolicy() {
        this.timeToKillInMilliSeconds = 0L;
    }

    public TimeoutExpirationPolicy(long timeToKillInMilliSeconds) {
        this.timeToKillInMilliSeconds = timeToKillInMilliSeconds;
    }

    public TimeoutExpirationPolicy(long timeToKill, TimeUnit timeUnit) {
        this.timeToKillInMilliSeconds = timeUnit.toMillis(timeToKill);
    }

    public boolean isExpired(TicketState ticketState) {
        return ticketState == null || System.currentTimeMillis() - ticketState.getLastTimeUsed() >= this.timeToKillInMilliSeconds;
    }
}

