/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegexUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexUtils.class);

    private RegexUtils() {
    }

    public static boolean isValidRegex(String pattern) {
        try {
            LOGGER.debug("Pattern {} is a valid regex.", (Object)Pattern.compile(pattern).pattern());
            return true;
        }
        catch (PatternSyntaxException exception) {
            return false;
        }
    }

    public static Pattern concatenate(Collection<String> requiredValues, boolean caseInsensitive) {
        StringBuilder builder = new StringBuilder(requiredValues.size());
        for (String requiredValue : requiredValues) {
            builder.append('(').append(requiredValue).append(")|");
        }
        String pattern = StringUtils.removeEnd((String)builder.toString(), (String)"|");
        if (RegexUtils.isValidRegex(pattern)) {
            return Pattern.compile(pattern, caseInsensitive ? 2 : 0);
        }
        return null;
    }
}

