/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.AbstractCentralAuthenticationServiceTests;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.CentralAuthenticationServiceImpl;
import org.jasig.cas.MockExpireUpdateTicketLogoutManager;
import org.jasig.cas.MockOnlyOneTicketRegistry;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationContext;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationSystemSupport;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.MixedPrincipalException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationServiceFactory;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.services.TestUtils;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.services.UnauthorizedServiceForPrincipalException;
import org.jasig.cas.services.UnauthorizedSsoServiceException;
import org.jasig.cas.ticket.AbstractTicketException;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.proxy.ProxyGrantingTicket;
import org.jasig.cas.ticket.proxy.ProxyTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.validation.Cas20WithoutProxyingValidationSpecification;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.mock.web.MockHttpServletRequest;

public class CentralAuthenticationServiceImplTests
extends AbstractCentralAuthenticationServiceTests {
    @Test(expected=AuthenticationException.class)
    public void verifyBadCredentialsOnTicketGrantingTicketCreation() throws Exception {
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Credential[])new Credential[]{org.jasig.cas.authentication.TestUtils.getCredentialsWithDifferentUsernameAndPassword()});
        this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
    }

    @Test
    public void verifyGoodCredentialsOnTicketGrantingTicketCreation() throws Exception {
        try {
            AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport());
            Assert.assertNotNull((Object)this.getCentralAuthenticationService().createTicketGrantingTicket(ctx));
        }
        catch (AbstractTicketException abstractTicketException) {
            Assert.fail((String)"Exception expected");
        }
    }

    @Test
    public void verifyDestroyTicketGrantingTicketWithNonExistantTicket() {
        this.getCentralAuthenticationService().destroyTicketGrantingTicket("test");
    }

    @Test
    public void verifyDestroyTicketGrantingTicketWithValidTicket() throws Exception {
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport());
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        this.getCentralAuthenticationService().destroyTicketGrantingTicket(ticketId.getId());
    }

    @Test(expected=RuntimeException.class)
    public void disallowNullCredentionalsWhenCreatingTicketGrantingTicket() throws Exception {
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Credential[])new Credential[1]);
        this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
    }

    @Test(expected=RuntimeException.class)
    public void disallowNullCredentialsArrayWhenCreatingTicketGrantingTicket() throws Exception {
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Credential[])new Credential[2]);
        this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
    }

    @Test(expected=ClassCastException.class)
    public void verifyDestroyTicketGrantingTicketWithInvalidTicket() throws Exception {
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport());
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket serviceTicketId = this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), this.getService(), ctx);
        this.getCentralAuthenticationService().destroyTicketGrantingTicket(serviceTicketId.getId());
    }

    @Test
    public void checkGrantingOfServiceTicketUsingDefaultTicketIdGen() throws Exception {
        Service mockService = (Service)Mockito.mock(Service.class);
        Mockito.when((Object)mockService.getId()).thenReturn((Object)"testDefault");
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)mockService);
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket serviceTicketId = this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), mockService, ctx);
        Assert.assertNotNull((Object)serviceTicketId);
    }

    @Test
    public void verifyGrantServiceTicketWithValidTicketGrantingTicket() throws Exception {
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport());
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), this.getService(), ctx);
    }

    @Test(expected=UnauthorizedServiceForPrincipalException.class)
    public void verifyGrantServiceTicketFailsAuthzRule() throws Exception {
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)CentralAuthenticationServiceImplTests.getService("TestServiceAttributeForAuthzFails"));
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), CentralAuthenticationServiceImplTests.getService("TestServiceAttributeForAuthzFails"), ctx);
    }

    @Test
    public void verifyGrantServiceTicketPassesAuthzRule() throws Exception {
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)CentralAuthenticationServiceImplTests.getService("TestServiceAttributeForAuthzPasses"));
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), CentralAuthenticationServiceImplTests.getService("TestServiceAttributeForAuthzPasses"), ctx);
    }

    @Test
    public void verifyGrantProxyTicketWithValidTicketGrantingTicket() throws Exception {
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport());
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket serviceTicketId = this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), this.getService(), ctx);
        AuthenticationContext ctx2 = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Credential[])new Credential[]{TestUtils.getHttpBasedServiceCredentials()});
        ProxyGrantingTicket pgt = this.getCentralAuthenticationService().createProxyGrantingTicket(serviceTicketId.getId(), ctx2);
        ProxyTicket pt = this.getCentralAuthenticationService().grantProxyTicket(pgt.getId(), this.getService());
        Assert.assertTrue((boolean)pt.getId().startsWith("PT"));
    }

    @Test(expected=AbstractTicketException.class)
    public void verifyGrantServiceTicketWithInvalidTicketGrantingTicket() throws Exception {
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport());
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        this.getCentralAuthenticationService().destroyTicketGrantingTicket(ticketId.getId());
        this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), this.getService(), ctx);
    }

    @Test
    public void verifyDelegateTicketGrantingTicketWithProperParams() throws Exception {
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)this.getService());
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket serviceTicketId = this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), this.getService(), ctx);
        AuthenticationContext ctx2 = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Credential[])new Credential[]{TestUtils.getHttpBasedServiceCredentials()});
        ProxyGrantingTicket pgt = this.getCentralAuthenticationService().createProxyGrantingTicket(serviceTicketId.getId(), ctx2);
        Assert.assertTrue((boolean)pgt.getId().startsWith("PGT"));
    }

    @Test(expected=AbstractTicketException.class)
    public void verifyDelegateTicketGrantingTicketWithBadServiceTicket() throws Exception {
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)this.getService());
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket serviceTicketId = this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), this.getService(), ctx);
        this.getCentralAuthenticationService().destroyTicketGrantingTicket(ticketId.getId());
        AuthenticationContext ctx2 = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Credential[])new Credential[]{TestUtils.getHttpBasedServiceCredentials()});
        this.getCentralAuthenticationService().createProxyGrantingTicket(serviceTicketId.getId(), ctx2);
    }

    @Test
    public void verifyGrantServiceTicketWithValidCredentials() throws Exception {
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)this.getService());
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), this.getService(), ctx);
    }

    @Test(expected=MixedPrincipalException.class)
    public void verifyGrantServiceTicketWithDifferentCredentials() throws Exception {
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Credential[])new Credential[]{org.jasig.cas.authentication.TestUtils.getCredentialsWithSameUsernameAndPassword((String)"testA")});
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        AuthenticationContext ctx2 = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Credential[])new Credential[]{org.jasig.cas.authentication.TestUtils.getCredentialsWithSameUsernameAndPassword((String)"testB")});
        this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), this.getService(), ctx2);
    }

    @Test
    public void verifyValidateServiceTicketWithValidService() throws Exception {
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport());
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), this.getService(), ctx);
        this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), this.getService());
    }

    @Test(expected=UnauthorizedServiceException.class)
    public void verifyValidateServiceTicketWithInvalidService() throws Exception {
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)CentralAuthenticationServiceImplTests.getService("test2"));
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), this.getService(), ctx);
        this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), CentralAuthenticationServiceImplTests.getService("test2"));
    }

    @Test(expected=AbstractTicketException.class)
    public void verifyValidateServiceTicketWithInvalidServiceTicket() throws Exception {
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)this.getService());
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), this.getService(), ctx);
        this.getCentralAuthenticationService().destroyTicketGrantingTicket(ticketGrantingTicket.getId());
        this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), this.getService());
    }

    @Test(expected=AbstractTicketException.class)
    public void verifyValidateServiceTicketNonExistantTicket() throws Exception {
        this.getCentralAuthenticationService().validateServiceTicket("google", this.getService());
    }

    @Test
    public void verifyValidateServiceTicketWithoutUsernameAttribute() throws Exception {
        UsernamePasswordCredential cred = org.jasig.cas.authentication.TestUtils.getCredentialsWithSameUsernameAndPassword();
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)this.getService());
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), this.getService(), ctx);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), this.getService());
        Authentication auth = assertion.getPrimaryAuthentication();
        Assert.assertEquals((Object)auth.getPrincipal().getId(), (Object)cred.getUsername());
    }

    @Test
    public void verifyValidateServiceTicketWithDefaultUsernameAttribute() throws Exception {
        Service svc = CentralAuthenticationServiceImplTests.getService("testDefault");
        UsernamePasswordCredential cred = org.jasig.cas.authentication.TestUtils.getCredentialsWithSameUsernameAndPassword();
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)svc);
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), svc, ctx);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), svc);
        Authentication auth = assertion.getPrimaryAuthentication();
        Assert.assertEquals((Object)auth.getPrincipal().getId(), (Object)cred.getUsername());
    }

    @Test
    public void verifyValidateServiceTicketWithUsernameAttribute() throws Exception {
        Service svc = CentralAuthenticationServiceImplTests.getService("eduPersonTest");
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)svc);
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), svc, ctx);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), svc);
        Assert.assertEquals((Object)"developer", (Object)assertion.getPrimaryAuthentication().getPrincipal().getId());
    }

    @Test
    public void verifyGrantServiceTicketWithCredsAndSsoFalse() throws Exception {
        Service svc = CentralAuthenticationServiceImplTests.getService("TestSsoFalse");
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)svc);
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), svc, ctx);
        Assert.assertNotNull((Object)serviceTicket);
    }

    @Test
    public void verifyGrantServiceTicketWithNoCredsAndSsoFalse() throws Exception {
        Service svc = CentralAuthenticationServiceImplTests.getService("TestSsoFalse");
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)svc);
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        Assert.assertNotNull((Object)this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), svc, null));
    }

    @Test(expected=UnauthorizedSsoServiceException.class)
    public void verifyGrantServiceTicketWithNoCredsAndSsoFalseAndSsoFalse() throws Exception {
        Service svc = CentralAuthenticationServiceImplTests.getService("TestSsoFalse");
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)svc);
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        Service service = CentralAuthenticationServiceImplTests.getService("eduPersonTest");
        this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), service, ctx);
        this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), svc, ctx);
    }

    @Test
    public void verifyValidateServiceTicketNoAttributesReturned() throws Exception {
        Service service = this.getService();
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)service);
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), service, ctx);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), service);
        Authentication auth = assertion.getPrimaryAuthentication();
        Assert.assertEquals((long)0L, (long)auth.getPrincipal().getAttributes().size());
    }

    @Test
    public void verifyValidateServiceTicketReturnAllAttributes() throws Exception {
        Service service = CentralAuthenticationServiceImplTests.getService("eduPersonTest");
        org.jasig.cas.authentication.TestUtils.getCredentialsWithSameUsernameAndPassword();
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)service);
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), service, ctx);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), service);
        Authentication auth = assertion.getPrimaryAuthentication();
        Assert.assertEquals((long)3L, (long)auth.getPrincipal().getAttributes().size());
    }

    @Test
    public void verifyValidateServiceTicketReturnOnlyAllowedAttribute() throws Exception {
        Service service = CentralAuthenticationServiceImplTests.getService("eduPersonTestInvalid");
        org.jasig.cas.authentication.TestUtils.getCredentialsWithSameUsernameAndPassword();
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)service);
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), service, ctx);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), service);
        Authentication auth = assertion.getPrimaryAuthentication();
        Map attributes = auth.getPrincipal().getAttributes();
        Assert.assertEquals((long)1L, (long)attributes.size());
        Assert.assertEquals((Object)"adopters", attributes.get("groupMembership"));
    }

    @Test
    public void verifyValidateServiceTicketAnonymous() throws Exception {
        Service service = CentralAuthenticationServiceImplTests.getService("testAnonymous");
        UsernamePasswordCredential cred = org.jasig.cas.authentication.TestUtils.getCredentialsWithSameUsernameAndPassword();
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)service);
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), service, ctx);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), service);
        Authentication auth = assertion.getPrimaryAuthentication();
        Assert.assertNotEquals((Object)cred.getUsername(), (Object)auth.getPrincipal().getId());
    }

    @Test
    public void verifyValidateServiceTicketWithInvalidUsernameAttribute() throws Exception {
        Service svc = CentralAuthenticationServiceImplTests.getService("eduPersonTestInvalid");
        UsernamePasswordCredential cred = org.jasig.cas.authentication.TestUtils.getCredentialsWithSameUsernameAndPassword();
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)svc);
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), svc, ctx);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), svc);
        Authentication auth = assertion.getPrimaryAuthentication();
        Assert.assertEquals((Object)auth.getPrincipal().getId(), (Object)cred.getUsername());
    }

    @Test
    public void authenticateTwiceWithRenew() throws AbstractTicketException, AuthenticationException {
        CentralAuthenticationService cas = this.getCentralAuthenticationService();
        Service svc = CentralAuthenticationServiceImplTests.getService("testDefault");
        org.jasig.cas.authentication.TestUtils.getCredentialsWithSameUsernameAndPassword();
        AuthenticationContext ctx = org.jasig.cas.authentication.TestUtils.getAuthenticationContext((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)svc);
        TicketGrantingTicket tgtId = cas.createTicketGrantingTicket(ctx);
        cas.grantServiceTicket(tgtId.getId(), svc, ctx);
        ServiceTicket st2Id = cas.grantServiceTicket(tgtId.getId(), svc, ctx);
        Assertion assertion = cas.validateServiceTicket(st2Id.getId(), svc);
        Cas20WithoutProxyingValidationSpecification validationSpecification = new Cas20WithoutProxyingValidationSpecification();
        Assert.assertTrue((boolean)validationSpecification.isSatisfiedBy(assertion));
    }

    @Test
    public void verifyDestroyRemoteRegistry() throws AbstractTicketException, AuthenticationException {
        MockOnlyOneTicketRegistry registry = new MockOnlyOneTicketRegistry();
        TicketGrantingTicketImpl tgt = new TicketGrantingTicketImpl("TGT-1", (Authentication)Mockito.mock(Authentication.class), (ExpirationPolicy)Mockito.mock(ExpirationPolicy.class));
        MockExpireUpdateTicketLogoutManager logoutManager = new MockExpireUpdateTicketLogoutManager(registry);
        registry.addTicket((Ticket)tgt);
        CentralAuthenticationServiceImpl cas = new CentralAuthenticationServiceImpl((TicketRegistry)registry, null, null, (LogoutManager)logoutManager);
        cas.setApplicationEventPublisher((ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class));
        cas.destroyTicketGrantingTicket(tgt.getId());
    }

    private static Service getService(String name) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("service", name);
        return new WebApplicationServiceFactory().createService((HttpServletRequest)request);
    }

    private Service getService() {
        return CentralAuthenticationServiceImplTests.getService("https://google.com");
    }
}

