/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import javax.validation.constraints.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.AuthenticationContext;
import org.jasig.cas.authentication.AuthenticationContextBuilder;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationSystemSupport;
import org.jasig.cas.authentication.AuthenticationTransaction;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.DefaultAuthenticationContextBuilder;
import org.jasig.cas.authentication.DefaultAuthenticationSystemSupport;
import org.jasig.cas.authentication.OneTimePasswordCredential;
import org.jasig.cas.authentication.TestUtils;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.UnsatisfiedAuthenticationPolicyException;
import org.jasig.cas.validation.Assertion;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"/mfa-test-context.xml"})
public class MultifactorAuthenticationTests {
    private static final Service NORMAL_SERVICE = MultifactorAuthenticationTests.newService("https://example.com/normal/");
    private static final Service HIGH_SERVICE = MultifactorAuthenticationTests.newService("https://example.com/high/");
    @NotNull
    @Autowired(required=false)
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport = new DefaultAuthenticationSystemSupport();
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService cas;

    @Test
    public void verifyAllowsAccessToNormalSecurityServiceWithPassword() throws Exception {
        AuthenticationContext ctx = this.processAuthenticationAttempt(NORMAL_SERVICE, new Credential[]{MultifactorAuthenticationTests.newUserPassCredentials("alice", "alice")});
        TicketGrantingTicket tgt = this.cas.createTicketGrantingTicket(ctx);
        Assert.assertNotNull((Object)tgt);
        ServiceTicket st = this.cas.grantServiceTicket(tgt.getId(), NORMAL_SERVICE, ctx);
        Assert.assertNotNull((Object)st);
    }

    @Test
    public void verifyAllowsAccessToNormalSecurityServiceWithOTP() throws Exception {
        AuthenticationContext ctx = this.processAuthenticationAttempt(NORMAL_SERVICE, new Credential[]{new OneTimePasswordCredential("alice", "31415")});
        TicketGrantingTicket tgt = this.cas.createTicketGrantingTicket(ctx);
        Assert.assertNotNull((Object)tgt);
        ServiceTicket st = this.cas.grantServiceTicket(tgt.getId(), NORMAL_SERVICE, ctx);
        Assert.assertNotNull((Object)st);
    }

    @Test(expected=UnsatisfiedAuthenticationPolicyException.class)
    public void verifyDeniesAccessToHighSecurityServiceWithPassword() throws Exception {
        AuthenticationContext ctx = this.processAuthenticationAttempt(HIGH_SERVICE, new Credential[]{MultifactorAuthenticationTests.newUserPassCredentials("alice", "alice")});
        TicketGrantingTicket tgt = this.cas.createTicketGrantingTicket(ctx);
        Assert.assertNotNull((Object)tgt);
        this.cas.grantServiceTicket(tgt.getId(), HIGH_SERVICE, ctx);
    }

    @Test(expected=UnsatisfiedAuthenticationPolicyException.class)
    public void verifyDeniesAccessToHighSecurityServiceWithOTP() throws Exception {
        AuthenticationContext ctx = this.processAuthenticationAttempt(HIGH_SERVICE, new Credential[]{new OneTimePasswordCredential("alice", "31415")});
        TicketGrantingTicket tgt = this.cas.createTicketGrantingTicket(ctx);
        Assert.assertNotNull((Object)tgt);
        ServiceTicket st = this.cas.grantServiceTicket(tgt.getId(), HIGH_SERVICE, ctx);
        Assert.assertNotNull((Object)st);
    }

    @Test
    public void verifyAllowsAccessToHighSecurityServiceWithPasswordAndOTP() throws Exception {
        AuthenticationContext ctx = this.processAuthenticationAttempt(HIGH_SERVICE, new Credential[]{MultifactorAuthenticationTests.newUserPassCredentials("alice", "alice"), new OneTimePasswordCredential("alice", "31415")});
        TicketGrantingTicket tgt = this.cas.createTicketGrantingTicket(ctx);
        Assert.assertNotNull((Object)tgt);
        ServiceTicket st = this.cas.grantServiceTicket(tgt.getId(), HIGH_SERVICE, ctx);
        Assert.assertNotNull((Object)st);
    }

    @Test
    public void verifyAllowsAccessToHighSecurityServiceWithPasswordAndOTPViaRenew() throws Exception {
        AuthenticationContext ctx = this.processAuthenticationAttempt(HIGH_SERVICE, new Credential[]{MultifactorAuthenticationTests.newUserPassCredentials("alice", "alice")});
        TicketGrantingTicket tgt = this.cas.createTicketGrantingTicket(ctx);
        Assert.assertNotNull((Object)tgt);
        AuthenticationContext ctx2 = this.processAuthenticationAttempt(HIGH_SERVICE, new Credential[]{MultifactorAuthenticationTests.newUserPassCredentials("alice", "alice"), new OneTimePasswordCredential("alice", "31415")});
        ServiceTicket st = this.cas.grantServiceTicket(tgt.getId(), HIGH_SERVICE, ctx2);
        Assert.assertNotNull((Object)st);
        Assertion assertion = this.cas.validateServiceTicket(st.getId(), HIGH_SERVICE);
        Assert.assertEquals((long)2L, (long)assertion.getPrimaryAuthentication().getSuccesses().size());
        Assert.assertTrue((boolean)assertion.getPrimaryAuthentication().getSuccesses().containsKey("passwordHandler"));
        Assert.assertTrue((boolean)assertion.getPrimaryAuthentication().getSuccesses().containsKey("oneTimePasswordHandler"));
        Assert.assertTrue((boolean)assertion.getPrimaryAuthentication().getAttributes().containsKey("successfulAuthenticationHandlers"));
    }

    private static UsernamePasswordCredential newUserPassCredentials(String user, String pass) {
        UsernamePasswordCredential userpass = new UsernamePasswordCredential();
        userpass.setUsername(user);
        userpass.setPassword(pass);
        return userpass;
    }

    private static Service newService(String id) {
        return TestUtils.getService((String)id);
    }

    private AuthenticationContext processAuthenticationAttempt(Service service, Credential ... credential) throws AuthenticationException {
        DefaultAuthenticationContextBuilder builder = new DefaultAuthenticationContextBuilder(this.authenticationSystemSupport.getPrincipalElectionStrategy());
        AuthenticationTransaction transaction = AuthenticationTransaction.wrap((Credential[])credential);
        this.authenticationSystemSupport.getAuthenticationTransactionManager().handle(transaction, (AuthenticationContextBuilder)builder);
        return builder.build(service);
    }
}

