/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.extension.clearpass;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;

public final class EhcacheBackedMap
implements Map<String, String> {
    @NotNull
    private final Cache cache;

    public EhcacheBackedMap(Cache cache) {
        this.cache = cache;
    }

    @Override
    public int size() {
        return this.cache.getSize();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.getSize() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("This operation is not supported on an Ehcache-backed Map");
    }

    @Override
    public String get(Object key) {
        Element element = this.cache.get(key);
        return element == null ? null : (String)((Object)element.getValue());
    }

    @Override
    public String put(String key, String value) {
        this.cache.put(new Element((Serializable)((Object)key), (Serializable)((Object)value)));
        return value;
    }

    @Override
    public String remove(Object key) {
        String keyValue = this.get(key);
        this.cache.remove(key);
        return keyValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        for (Map.Entry<? extends String, ? extends String> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.cache.removeAll();
    }

    @Override
    public Set<String> keySet() {
        return new HashSet<String>(this.cache.getKeys());
    }

    @Override
    public Collection<String> values() {
        Set<String> keys = this.keySet();
        ArrayList<String> values = new ArrayList<String>();
        for (String key : keys) {
            String value = this.get(key);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        Set<String> keys = this.keySet();
        HashSet<Map.Entry<String, String>> entries = new HashSet<Map.Entry<String, String>>();
        for (String key : keys) {
            Element element = this.cache.get((Serializable)((Object)key));
            if (element == null) continue;
            entries.add(new ElementMapEntry(element));
        }
        return entries;
    }

    protected final class ElementMapEntry
    implements Map.Entry<String, String> {
        private final Element element;

        public ElementMapEntry(Element element) {
            this.element = element;
        }

        @Override
        public String getKey() {
            return (String)((Object)this.element.getKey());
        }

        @Override
        public String getValue() {
            return (String)((Object)this.element.getValue());
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException("Operation Not Supported");
        }
    }
}

