/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.io.Serializable;
import java.util.Collection;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.style.ToStringCreator;

public final class EhCacheTicketRegistry
extends AbstractDistributedTicketRegistry
implements InitializingBean {
    private Cache serviceTicketsCache = null;
    private Cache ticketGrantingTicketsCache = null;
    private boolean supportRegistryState = true;

    public EhCacheTicketRegistry() {
    }

    public EhCacheTicketRegistry(Cache serviceTicketsCache, Cache ticketGrantingTicketsCache) {
        this.setServiceTicketsCache(serviceTicketsCache);
        this.setTicketGrantingTicketsCache(ticketGrantingTicketsCache);
    }

    public EhCacheTicketRegistry(Cache serviceTicketsCache, Cache ticketGrantingTicketsCache, boolean supportRegistryState) {
        this(serviceTicketsCache, ticketGrantingTicketsCache);
        this.setSupportRegistryState(supportRegistryState);
    }

    public void addTicket(Ticket ticket) {
        Element element = new Element((Serializable)((Object)ticket.getId()), (Serializable)ticket);
        if (ticket instanceof ServiceTicket) {
            this.log.debug("Adding service ticket {} to the cache", (Object)ticket.getId(), (Object)this.serviceTicketsCache.getName());
            this.serviceTicketsCache.put(element);
        } else if (ticket instanceof TicketGrantingTicket) {
            this.log.debug("Adding ticket granting ticket {} to the cache {}", (Object)ticket.getId(), (Object)this.ticketGrantingTicketsCache.getName());
            this.ticketGrantingTicketsCache.put(element);
        } else {
            throw new IllegalArgumentException("Invalid ticket type " + ticket);
        }
    }

    public boolean deleteTicket(String ticketId) {
        if (StringUtils.isBlank((String)ticketId)) {
            return false;
        }
        return this.serviceTicketsCache.remove((Serializable)((Object)ticketId)) || this.ticketGrantingTicketsCache.remove((Serializable)((Object)ticketId));
    }

    public Ticket getTicket(String ticketId) {
        if (ticketId == null) {
            return null;
        }
        Element element = this.serviceTicketsCache.get((Serializable)((Object)ticketId));
        if (element == null) {
            element = this.ticketGrantingTicketsCache.get((Serializable)((Object)ticketId));
        }
        return element == null ? null : this.getProxiedTicketInstance((Ticket)element.getValue());
    }

    public Collection<Ticket> getTickets() {
        throw new UnsupportedOperationException("GetTickets not supported.");
    }

    public void setServiceTicketsCache(Cache serviceTicketsCache) {
        this.serviceTicketsCache = serviceTicketsCache;
    }

    public void setTicketGrantingTicketsCache(Cache ticketGrantingTicketsCache) {
        this.ticketGrantingTicketsCache = ticketGrantingTicketsCache;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("ticketGrantingTicketsCache", (Object)this.ticketGrantingTicketsCache).append("serviceTicketsCache", (Object)this.serviceTicketsCache).toString();
    }

    protected void updateTicket(Ticket ticket) {
        this.addTicket(ticket);
    }

    protected boolean needsCallback() {
        return false;
    }

    public void setSupportRegistryState(boolean supportRegistryState) {
        this.supportRegistryState = supportRegistryState;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.serviceTicketsCache == null || this.ticketGrantingTicketsCache == null) {
            throw new BeanInstantiationException(((Object)((Object)this)).getClass(), "Both serviceTicketsCache and ticketGrantingTicketsCache are required properties.");
        }
        if (this.log.isDebugEnabled()) {
            CacheConfiguration config = this.serviceTicketsCache.getCacheConfiguration();
            this.log.debug("serviceTicketsCache.maxElementsInMemory={}", (Object)config.getMaxEntriesLocalHeap());
            this.log.debug("serviceTicketsCache.maxElementsOnDisk={}", (Object)config.getMaxElementsOnDisk());
            this.log.debug("serviceTicketsCache.overflowToDisk={}", (Object)config.isOverflowToDisk());
            this.log.debug("serviceTicketsCache.timeToLive={}", (Object)config.getTimeToLiveSeconds());
            this.log.debug("serviceTicketsCache.timeToIdle={}", (Object)config.getTimeToIdleSeconds());
            config = this.ticketGrantingTicketsCache.getCacheConfiguration();
            this.log.debug("ticketGrantingTicketsCache.maxElementsInMemory={}", (Object)config.getMaxEntriesLocalHeap());
            this.log.debug("ticketGrantingTicketsCache.maxElementsOnDisk={}", (Object)config.getMaxElementsOnDisk());
            this.log.debug("ticketGrantingTicketsCache.overflowToDisk={}", (Object)config.isOverflowToDisk());
            this.log.debug("ticketGrantingTicketsCache.timeToLive={}", (Object)config.getTimeToLiveSeconds());
            this.log.debug("ticketGrantingTicketsCache.timeToIdle={}", (Object)config.getTimeToIdleSeconds());
        }
    }

    public int sessionCount() {
        return BooleanUtils.toInteger((boolean)this.supportRegistryState, (int)this.ticketGrantingTicketsCache.getKeysWithExpiryCheck().size(), (int)super.sessionCount());
    }

    public int serviceTicketCount() {
        return BooleanUtils.toInteger((boolean)this.supportRegistryState, (int)this.serviceTicketsCache.getKeysWithExpiryCheck().size(), (int)super.serviceTicketCount());
    }
}

