/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JBossCacheTicketRegistry
extends AbstractDistributedTicketRegistry {
    private static final String FQN_TICKET = "ticket";
    @NotNull
    private Cache<String, Ticket> cache;

    protected void updateTicket(Ticket ticket) {
        try {
            this.cache.put(FQN_TICKET, (Object)ticket.getId(), (Object)ticket);
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
    }

    public void addTicket(Ticket ticket) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding ticket to registry for: " + ticket.getId());
            }
            this.cache.put(FQN_TICKET, (Object)ticket.getId(), (Object)ticket);
        }
        catch (CacheException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean deleteTicket(String ticketId) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Removing ticket from registry for: " + ticketId);
            }
            return this.cache.remove(FQN_TICKET, (Object)ticketId) != null;
        }
        catch (CacheException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Ticket getTicket(String ticketId) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Retrieving ticket from registry for: " + ticketId);
            }
            return this.getProxiedTicketInstance((Ticket)this.cache.get(FQN_TICKET, (Object)ticketId));
        }
        catch (CacheException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Collection<Ticket> getTickets() {
        try {
            Node node = this.cache.getNode(FQN_TICKET);
            if (node == null) {
                return Collections.emptyList();
            }
            Set keys = node.getKeys();
            ArrayList<Ticket> list = new ArrayList<Ticket>();
            for (String key : keys) {
                list.add((Ticket)node.get((Object)key));
            }
            return list;
        }
        catch (CacheException cacheException) {
            return Collections.emptyList();
        }
    }

    public void setCache(Cache<String, Ticket> cache) {
        this.cache = cache;
    }
}

