/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.ClassSerializer;
import com.esotericsoftware.kryo.serialize.DateSerializer;
import java.net.URL;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.spy.memcached.CachedData;
import net.spy.memcached.transcoders.Transcoder;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.ImmutableAuthentication;
import org.jasig.cas.authentication.principal.SimpleWebApplicationServiceImpl;
import org.jasig.cas.ticket.ServiceTicketImpl;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.registry.support.kryo.serial.SimpleWebApplicationServiceSerializer;
import org.jasig.cas.ticket.registry.support.kryo.serial.URLSerializer;
import org.jasig.cas.ticket.support.HardTimeoutExpirationPolicy;
import org.jasig.cas.ticket.support.MultiTimeUseOrTimeoutExpirationPolicy;
import org.jasig.cas.ticket.support.NeverExpiresExpirationPolicy;
import org.jasig.cas.ticket.support.RememberMeDelegatingExpirationPolicy;
import org.jasig.cas.ticket.support.ThrottledUseAndTimeoutExpirationPolicy;
import org.jasig.cas.ticket.support.TicketGrantingTicketExpirationPolicy;
import org.jasig.cas.ticket.support.TimeoutExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoTranscoder
implements Transcoder<Object> {
    private final Kryo kryo = new Kryo();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int bufferSize;
    private Map<Class<?>, Serializer> serializerMap;

    public KryoTranscoder(int initialBufferSize) {
        this.bufferSize = initialBufferSize;
    }

    public void setSerializerMap(Map<Class<?>, Serializer> map) {
        this.serializerMap = map;
    }

    public void initialize() {
        this.kryo.register(ArrayList.class);
        this.kryo.register(BasicCredentialMetaData.class);
        this.kryo.register(Class.class, (Serializer)new ClassSerializer(this.kryo));
        this.kryo.register(Date.class, (Serializer)new DateSerializer());
        this.kryo.register(HardTimeoutExpirationPolicy.class);
        this.kryo.register(HashMap.class);
        this.kryo.register(HandlerResult.class);
        this.kryo.register(ImmutableAuthentication.class);
        this.kryo.register(MultiTimeUseOrTimeoutExpirationPolicy.class);
        this.kryo.register(NeverExpiresExpirationPolicy.class);
        this.kryo.register(RememberMeDelegatingExpirationPolicy.class);
        this.kryo.register(ServiceTicketImpl.class);
        this.kryo.register(SimpleWebApplicationServiceImpl.class, (Serializer)new SimpleWebApplicationServiceSerializer(this.kryo));
        this.kryo.register(ThrottledUseAndTimeoutExpirationPolicy.class);
        this.kryo.register(TicketGrantingTicketExpirationPolicy.class);
        this.kryo.register(TicketGrantingTicketImpl.class);
        this.kryo.register(TimeoutExpirationPolicy.class);
        this.kryo.register(URL.class, (Serializer)new URLSerializer(this.kryo));
        if (this.serializerMap != null) {
            for (Class<?> clazz : this.serializerMap.keySet()) {
                this.kryo.register(clazz, this.serializerMap.get(clazz));
            }
        }
        this.kryo.setRegistrationOptional(true);
    }

    public boolean asyncDecode(CachedData d) {
        return false;
    }

    public CachedData encode(Object o) {
        byte[] bytes = this.encodeToBytes(o);
        return new CachedData(0, bytes, bytes.length);
    }

    public Object decode(CachedData d) {
        return this.kryo.readClassAndObject(ByteBuffer.wrap(d.getData()));
    }

    public int getMaxSize() {
        return 0x1400000;
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    private byte[] encodeToBytes(Object o) {
        int factor = 1;
        byte[] result = null;
        ByteBuffer buffer = Kryo.getContext().getBuffer(this.bufferSize * factor);
        while (result == null) {
            try {
                this.kryo.writeClassAndObject(buffer, o);
                result = new byte[buffer.flip().limit()];
                buffer.get(result);
            }
            catch (SerializationException e) {
                Throwable rootCause = e;
                while (rootCause.getCause() != null) {
                    rootCause = rootCause.getCause();
                }
                if (rootCause instanceof BufferOverflowException) {
                    buffer = ByteBuffer.allocate(this.bufferSize * ++factor);
                    this.logger.warn("Buffer overflow while encoding {}", o);
                    continue;
                }
                throw e;
            }
        }
        return result;
    }
}

