/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.generic;

import java.util.Collections;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;

public class AcceptUsersAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    @NotNull
    private Map<String, String> users;

    protected final boolean authenticateUsernamePasswordInternal(UsernamePasswordCredentials credentials) {
        String transformedUsername = this.getPrincipalNameTransformer().transform(credentials.getUsername());
        String cachedPassword = this.users.get(transformedUsername);
        if (cachedPassword == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("The user [" + transformedUsername + "] was not found in the map.");
            }
            return false;
        }
        String encodedPassword = this.getPasswordEncoder().encode(credentials.getPassword());
        return cachedPassword.equals(encodedPassword);
    }

    public final void setUsers(Map<String, String> users) {
        this.users = Collections.unmodifiableMap(users);
    }
}

