/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.authentication.AbstractPasswordPolicyEnforcer;
import org.jasig.cas.authentication.LdapPasswordPolicyEnforcementException;
import org.jasig.cas.util.LdapUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapPasswordPolicyEnforcer
extends AbstractPasswordPolicyEnforcer {
    private static final DateTimeZone DEFAULT_TIME_ZONE = DateTimeZone.UTC;
    private static final int DEFAULT_MAX_NUMBER_OF_RESULTS = 10;
    private static final int DEFAULT_TIMEOUT = 1000;
    private static final long YEARS_FROM_1601_1970 = 369L;
    private static final int PASSWORD_STATUS_PASS = -1;
    private static final double PASSWORD_STATUS_NEVER_EXPIRE = Math.pow(2.0, 63.0) - 1.0;
    private static final long TOTAL_SECONDS_FROM_1601_1970 = 11644473600L;
    private static final int[] VALID_SCOPE_VALUES;
    private String filter;
    private boolean ignorePartialResultException = false;
    private LdapTemplate ldapTemplate;
    private int maxNumberResults = 10;
    private String noWarnAttribute;
    private List<String> noWarnValues;
    private int scope = 2;
    private String searchBase;
    private int timeout = 1000;
    private int validDays = 180;
    private int warningDays = 30;
    protected String dateAttribute;
    protected String dateFormat;
    protected String validDaysAttribute;
    protected Boolean warnAll = Boolean.FALSE;
    protected String warningDaysAttribute;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        VALID_SCOPE_VALUES = nArray;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.ldapTemplate, (String)"ldapTemplate cannot be null");
        Assert.notNull((Object)this.filter, (String)"filter cannot be null");
        Assert.notNull((Object)this.searchBase, (String)"searchBase cannot be null");
        Assert.notNull((Object)this.warnAll, (String)"warnAll cannot be null");
        Assert.notNull((Object)this.dateAttribute, (String)"dateAttribute cannot be null");
        Assert.notNull((Object)this.dateFormat, (String)"dateFormat cannot be null");
        Assert.isTrue((this.filter.contains("%u") || this.filter.contains("%U") ? 1 : 0) != 0, (String)"filter must contain %u");
        this.ldapTemplate.setIgnorePartialResultException(this.ignorePartialResultException);
        int[] nArray = VALID_SCOPE_VALUES;
        int n = VALID_SCOPE_VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            if (this.scope == element) {
                return;
            }
            ++n2;
        }
        throw new IllegalStateException("You must set a valid scope. Valid scope values are: " + Arrays.toString(VALID_SCOPE_VALUES));
    }

    @Override
    public long getNumberOfDaysToPasswordExpirationDate(String userId) throws LdapPasswordPolicyEnforcementException {
        String msgToLog = null;
        LdapPasswordPolicyResult ldapResult = this.getEnforcedPasswordPolicy(userId);
        if (ldapResult == null) {
            this.logDebug("Skipping all password policy checks...");
            return -1L;
        }
        if (!StringUtils.isEmpty((String)this.noWarnAttribute)) {
            this.logDebug("No warning attribute value for " + this.noWarnAttribute + " is set to: " + ldapResult.getNoWarnAttributeResult());
        }
        if (this.isPasswordSetToNeverExpire(ldapResult.getNoWarnAttributeResult())) {
            this.logDebug("Account password will never expire. Skipping password warning check...");
            return -1L;
        }
        if (StringUtils.isEmpty((String)ldapResult.getWarnDaysResult())) {
            this.logDebug("No warning days value is found for " + userId + ". Using system default of " + this.warningDays);
        } else {
            this.warningDays = Integer.parseInt(ldapResult.getWarnDaysResult());
        }
        if (StringUtils.isEmpty((String)ldapResult.getValidDaysResult())) {
            this.logDebug("No maximum password valid days found for " + ldapResult.getUserId() + ". Using system default of " + this.validDays + " days");
        } else {
            this.validDays = Integer.parseInt(ldapResult.getValidDaysResult());
        }
        DateTime expireTime = this.getExpirationDateToUse(ldapResult.getDateResult());
        if (expireTime == null) {
            msgToLog = "Expiration date cannot be determined for date " + ldapResult.getDateResult();
            LdapPasswordPolicyEnforcementException exc = new LdapPasswordPolicyEnforcementException(msgToLog);
            this.logError(msgToLog, (Exception)((Object)exc));
            throw exc;
        }
        return this.getDaysToExpirationDate(userId, expireTime);
    }

    public void setContextSource(ContextSource contextSource) {
        this.ldapTemplate = new LdapTemplate(contextSource);
    }

    public void setDateAttribute(String dateAttribute) {
        this.dateAttribute = dateAttribute;
        this.logDebug("Date attribute: " + dateAttribute);
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        this.logDebug("Date format: " + dateFormat);
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.logDebug("Search filter: " + filter);
    }

    public void setIgnorePartialResultException(boolean ignorePartialResultException) {
        this.ignorePartialResultException = ignorePartialResultException;
    }

    public void setMaxNumberResults(int maxNumberResults) {
        this.maxNumberResults = maxNumberResults;
    }

    public void setNoWarnAttribute(String noWarnAttribute) {
        this.noWarnAttribute = noWarnAttribute;
        this.logDebug("Attribute to flag warning bypass: " + noWarnAttribute);
    }

    public void setNoWarnValues(List<String> noWarnValues) {
        this.noWarnValues = noWarnValues;
        this.logDebug("Value to flag warning bypass: " + noWarnValues.toString());
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
        this.logDebug("Search base: " + searchBase);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
        this.logDebug("Timeout: " + this.timeout);
    }

    public void setValidDays(int validDays) {
        this.validDays = validDays;
        this.logDebug("Password valid days: " + validDays);
    }

    public void setValidDaysAttribute(String validDaysAttribute) {
        this.validDaysAttribute = validDaysAttribute;
        this.logDebug("Valid days attribute: " + validDaysAttribute);
    }

    public void setWarnAll(Boolean warnAll) {
        this.warnAll = warnAll;
        this.logDebug("warnAll: " + warnAll);
    }

    public void setWarningDays(int warningDays) {
        this.warningDays = warningDays;
        this.logDebug("Default warningDays: " + warningDays);
    }

    public void setWarningDaysAttribute(String warnDays) {
        this.warningDaysAttribute = warnDays;
        this.logDebug("Warning days attribute: " + warnDays);
    }

    private DateTime convertDateToActiveDirectoryFormat(String pswValue) {
        long l = Long.parseLong(pswValue.trim());
        long totalSecondsSince1601 = l / 10000000L;
        long totalSecondsSince1970 = totalSecondsSince1601 - 11644473600L;
        DateTime dt = new DateTime(totalSecondsSince1970 * 1000L, DEFAULT_TIME_ZONE);
        this.logInfo("Recalculated " + this.dateFormat + " " + this.dateAttribute + " attribute to " + dt.toString());
        return dt;
    }

    private DateTime formatDateByPattern(String ldapResult) {
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)this.dateFormat);
        DateTime date = new DateTime((Object)DateTime.parse((String)ldapResult, (DateTimeFormatter)fmt), DEFAULT_TIME_ZONE);
        return date;
    }

    private DateTime getExpirationDateToUse(String ldapDateResult) {
        DateTime dateValue = null;
        dateValue = this.isUsingActiveDirectory() ? this.convertDateToActiveDirectoryFormat(ldapDateResult) : this.formatDateByPattern(ldapDateResult);
        DateTime expireDate = dateValue.plusDays(this.validDays);
        this.logDebug("Retrieved date value " + dateValue.toString() + " for date attribute " + this.dateAttribute + " and added " + this.validDays + " days. The final expiration date is " + expireDate.toString());
        return expireDate;
    }

    private long getDaysToExpirationDate(String userId, DateTime expireDate) throws LdapPasswordPolicyEnforcementException {
        this.logDebug("Calculating number of days left to the expiration date for user " + userId);
        DateTime currentTime = new DateTime(DEFAULT_TIME_ZONE);
        this.logInfo("Current date is " + currentTime.toString());
        this.logInfo("Expiration date is " + expireDate.toString());
        Days d = Days.daysBetween((ReadableInstant)currentTime, (ReadableInstant)expireDate);
        int daysToExpirationDate = d.getDays();
        if (expireDate.equals((Object)currentTime) || expireDate.isBefore((ReadableInstant)currentTime)) {
            String msgToLog = "Authentication failed because account password has expired with " + daysToExpirationDate + " to expiration date. ";
            msgToLog = String.valueOf(msgToLog) + "Verify the value of the " + this.dateAttribute + " attribute and make sure it's not before the current date, which is " + currentTime.toString();
            LdapPasswordPolicyEnforcementException exc = new LdapPasswordPolicyEnforcementException(msgToLog);
            this.logError(msgToLog, (Exception)((Object)exc));
            throw exc;
        }
        DateTime warnPeriod = new DateTime((Object)DateTime.parse((String)expireDate.toString()), DEFAULT_TIME_ZONE);
        warnPeriod = warnPeriod.minusDays(this.warningDays);
        this.logInfo("Warning period begins on " + warnPeriod.toString());
        if (this.warnAll.booleanValue()) {
            this.logInfo("Warning all. The password for " + userId + " will expire in " + daysToExpirationDate + " days.");
        } else if (currentTime.equals((Object)warnPeriod) || currentTime.isAfter((ReadableInstant)warnPeriod)) {
            this.logInfo("Password will expire in " + daysToExpirationDate + " days.");
        } else {
            this.logInfo("Password is not expiring. " + daysToExpirationDate + " days left to the warning");
            daysToExpirationDate = -1;
        }
        return daysToExpirationDate;
    }

    private LdapPasswordPolicyResult getEnforcedPasswordPolicy(String userId) {
        LdapPasswordPolicyResult ldapResult = null;
        ldapResult = this.getResultsFromLdap(userId);
        if (ldapResult == null) {
            String msgToLog = "No entry was found for user " + userId + ". Verify your LPPE settings. ";
            msgToLog = String.valueOf(msgToLog) + "If you are not using LPPE, set the 'enabled' property to false. ";
            msgToLog = String.valueOf(msgToLog) + "Password policy enforcement is currently turned on but not configured.";
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(msgToLog);
            }
        }
        return ldapResult;
    }

    private LdapPasswordPolicyResult getResultsFromLdap(final String userId) {
        ArrayList<String> attributeList = new ArrayList<String>();
        attributeList.add(this.dateAttribute);
        if (this.warningDaysAttribute != null) {
            attributeList.add(this.warningDaysAttribute);
        }
        if (this.validDaysAttribute != null) {
            attributeList.add(this.validDaysAttribute);
        }
        if (this.noWarnAttribute != null) {
            attributeList.add(this.noWarnAttribute);
        }
        String[] attributeIds = new String[attributeList.size()];
        attributeList.toArray(attributeIds);
        String searchFilter = LdapUtils.getFilterWithValues(this.filter, userId);
        this.logDebug("Starting search with searchFilter: " + searchFilter);
        String attributeListLog = attributeIds[0];
        int i = 1;
        while (i < attributeIds.length) {
            attributeListLog = attributeListLog.concat(":" + attributeIds[i]);
            ++i;
        }
        this.logDebug("Returning attributes " + attributeListLog);
        try {
            AttributesMapper mapper = new AttributesMapper(){

                public Object mapFromAttributes(Attributes attrs) throws NamingException {
                    LdapPasswordPolicyResult result = new LdapPasswordPolicyResult(userId);
                    if (LdapPasswordPolicyEnforcer.this.dateAttribute != null && attrs.get(LdapPasswordPolicyEnforcer.this.dateAttribute) != null) {
                        String date = (String)attrs.get(LdapPasswordPolicyEnforcer.this.dateAttribute).get();
                        result.setDateResult(date);
                    }
                    if (LdapPasswordPolicyEnforcer.this.warningDaysAttribute != null && attrs.get(LdapPasswordPolicyEnforcer.this.warningDaysAttribute) != null) {
                        String warn = (String)attrs.get(LdapPasswordPolicyEnforcer.this.warningDaysAttribute).get();
                        result.setWarnDaysResult(warn);
                    }
                    if (LdapPasswordPolicyEnforcer.this.noWarnAttribute != null && attrs.get(LdapPasswordPolicyEnforcer.this.noWarnAttribute) != null) {
                        String attrib = (String)attrs.get(LdapPasswordPolicyEnforcer.this.noWarnAttribute).get();
                        result.setNoWarnAttributeResult(attrib);
                    }
                    if (attrs.get(LdapPasswordPolicyEnforcer.this.validDaysAttribute) != null) {
                        String valid = (String)attrs.get(LdapPasswordPolicyEnforcer.this.validDaysAttribute).get();
                        result.setValidDaysResult(valid);
                    }
                    return result;
                }
            };
            List LdapResultList = this.ldapTemplate.search(this.searchBase, searchFilter, this.getSearchControls(attributeIds), mapper);
            if (LdapResultList.size() > 0) {
                return (LdapPasswordPolicyResult)LdapResultList.get(0);
            }
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
        }
        return null;
    }

    private SearchControls getSearchControls(String[] attributeIds) {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(this.scope);
        constraints.setReturningAttributes(attributeIds);
        constraints.setTimeLimit(this.timeout);
        constraints.setCountLimit(this.maxNumberResults);
        return constraints;
    }

    private boolean isPasswordSetToNeverExpire(String pswValue) {
        boolean ignoreChecks = this.noWarnValues.contains(pswValue);
        if (!ignoreChecks && StringUtils.isNumeric((String)pswValue)) {
            double psw = Double.parseDouble(pswValue);
            ignoreChecks = psw == PASSWORD_STATUS_NEVER_EXPIRE;
        }
        return ignoreChecks;
    }

    private boolean isUsingActiveDirectory() {
        return this.dateFormat.equalsIgnoreCase("ActiveDirectory") || this.dateFormat.equalsIgnoreCase("AD");
    }

    private void logDebug(String log) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(log);
        }
    }

    private void logError(String log, Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void logInfo(String log) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(log);
        }
    }

    private static final class LdapPasswordPolicyResult {
        private String dateResult = null;
        private String noWarnAttributeResult = null;
        private String userId = null;
        private String validDaysResult = null;
        private String warnDaysResult = null;

        public LdapPasswordPolicyResult(String userId) {
            this.userId = userId;
        }

        public String getDateResult() {
            return this.dateResult;
        }

        public String getNoWarnAttributeResult() {
            return this.noWarnAttributeResult;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getValidDaysResult() {
            return this.validDaysResult;
        }

        public String getWarnDaysResult() {
            return this.warnDaysResult;
        }

        public void setDateResult(String date) {
            this.dateResult = date;
        }

        public void setNoWarnAttributeResult(String noWarnAttributeResult) {
            this.noWarnAttributeResult = noWarnAttributeResult;
        }

        public void setValidDaysResult(String valid) {
            this.validDaysResult = valid;
        }

        public void setWarnDaysResult(String warn) {
            this.warnDaysResult = warn;
        }
    }
}

