/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.Arrays;
import javax.naming.directory.SearchControls;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.principal.AbstractPersonDirectoryCredentialsToPrincipalResolver;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;

public abstract class AbstractLdapPersonDirectoryCredentialsToPrincipalResolver
extends AbstractPersonDirectoryCredentialsToPrincipalResolver {
    private static final int DEFAULT_MAX_NUMBER_OF_RESULTS = 2;
    private static final int DEFAULT_TIMEOUT = 1000;
    @NotNull
    private LdapTemplate ldapTemplate;
    @NotNull
    private String filter;
    @NotNull
    private String[] attributeIds;
    @NotNull
    private String searchBase;
    @Min(value=0L)
    @Max(value=2L)
    private int scope = 2;
    private int timeout = 1000;

    protected final SearchControls getSearchControls() {
        SearchControls constraints = new SearchControls();
        if (this.log.isDebugEnabled()) {
            this.log.debug("returning searchcontrols: scope=" + this.scope + "; search base=" + this.searchBase + "; attributes=" + Arrays.toString(this.attributeIds) + "; timeout=" + this.timeout);
        }
        constraints.setSearchScope(this.scope);
        constraints.setReturningAttributes(this.attributeIds);
        constraints.setTimeLimit(this.timeout);
        constraints.setCountLimit(2L);
        return constraints;
    }

    public final void setContextSource(ContextSource contextSource) {
        this.ldapTemplate = new LdapTemplate(contextSource);
        this.ldapTemplate.setIgnorePartialResultException(true);
    }

    public final void setFilter(String filter) {
        this.filter = filter;
    }

    public final void setPrincipalAttributeName(String principalAttributeName) {
        this.attributeIds = new String[]{principalAttributeName};
    }

    public final void setScope(int scope) {
        this.scope = scope;
    }

    public final void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public final void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected final String getFilter() {
        return this.filter;
    }

    protected final String[] getAttributeIds() {
        return this.attributeIds;
    }

    protected final String getSearchBase() {
        return this.searchBase;
    }

    protected final int getTimeout() {
        return this.timeout;
    }

    protected final LdapTemplate getLdapTemplate() {
        return this.ldapTemplate;
    }
}

