/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.authentication;

import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationMetaDataPopulator;
import org.jasig.cas.authentication.MutableAuthentication;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.support.oauth.authentication.principal.OAuthCredentials;

public final class OAuthAuthenticationMetaDataPopulator
implements AuthenticationMetaDataPopulator {
    public Authentication populateAttributes(Authentication authentication, Credentials credentials) {
        if (credentials instanceof OAuthCredentials) {
            OAuthCredentials oauthCredentials = (OAuthCredentials)credentials;
            SimplePrincipal simplePrincipal = new SimplePrincipal(authentication.getPrincipal().getId(), oauthCredentials.getUserProfile().getAttributes());
            MutableAuthentication mutableAuthentication = new MutableAuthentication((Principal)simplePrincipal, authentication.getAuthenticatedDate());
            mutableAuthentication.getAttributes().putAll(authentication.getAttributes());
            mutableAuthentication.getAttributes().put("providerType", oauthCredentials.getCredential().getProviderType());
            return mutableAuthentication;
        }
        return authentication;
    }
}

