/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.support.oauth.OAuthUtils;
import org.jasig.cas.support.oauth.web.BaseOAuthWrapperController;
import org.jasig.cas.support.oauth.web.OAuth20AccessTokenController;
import org.jasig.cas.support.oauth.web.OAuth20AuthorizeController;
import org.jasig.cas.support.oauth.web.OAuth20CallbackAuthorizeController;
import org.jasig.cas.support.oauth.web.OAuth20ProfileController;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public final class OAuth20WrapperController
extends BaseOAuthWrapperController
implements InitializingBean {
    private AbstractController authorizeController;
    private AbstractController callbackAuthorizeController;
    private AbstractController accessTokenController;
    private AbstractController profileController;

    public void afterPropertiesSet() throws Exception {
        this.authorizeController = new OAuth20AuthorizeController(this.servicesManager, this.loginUrl);
        this.callbackAuthorizeController = new OAuth20CallbackAuthorizeController();
        this.accessTokenController = new OAuth20AccessTokenController(this.servicesManager, this.ticketRegistry, this.timeout);
        this.profileController = new OAuth20ProfileController(this.ticketRegistry);
    }

    @Override
    protected ModelAndView internalHandleRequest(String method, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if ("authorize".equals(method)) {
            return this.authorizeController.handleRequest(request, response);
        }
        if ("callbackAuthorize".equals(method)) {
            return this.callbackAuthorizeController.handleRequest(request, response);
        }
        if ("accessToken".equals(method)) {
            return this.accessTokenController.handleRequest(request, response);
        }
        if ("profile".equals(method)) {
            return this.profileController.handleRequest(request, response);
        }
        this.log.error("Unknown method : {}", (Object)method);
        OAuthUtils.writeTextError(response, "invalid_request", 200);
        return null;
    }
}

