/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.openid.authentication.principal;

import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.jasig.cas.authentication.handler.DefaultPasswordEncoder;
import org.jasig.cas.authentication.handler.PasswordEncoder;
import org.jasig.cas.authentication.principal.AbstractWebApplicationService;
import org.jasig.cas.authentication.principal.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class OpenIdService
extends AbstractWebApplicationService {
    protected static final Logger LOG = LoggerFactory.getLogger(OpenIdService.class);
    private static final long serialVersionUID = 5776500133123291301L;
    private static final String CONST_PARAM_SERVICE = "openid.return_to";
    private static final PasswordEncoder ENCODER = new DefaultPasswordEncoder("SHA1");
    private static final KeyGenerator keyGenerator;
    private String identity;
    private final SecretKey sharedSecret;
    private final String signature;

    static {
        try {
            keyGenerator = KeyGenerator.getInstance("HmacSHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected OpenIdService(String id, String originalUrl, String artifactId, String openIdIdentity, String signature) {
        super(id, originalUrl, artifactId, null);
        this.identity = openIdIdentity;
        this.signature = signature;
        this.sharedSecret = keyGenerator.generateKey();
    }

    protected String generateHash(String value) {
        try {
            Mac sha1 = Mac.getInstance("HmacSHA1");
            sha1.init(this.sharedSecret);
            return Base64.encodeBase64String((byte[])sha1.doFinal(value.getBytes()));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return Base64.encodeBase64String((byte[])ENCODER.encode(value).getBytes());
        }
    }

    public Response getResponse(String ticketId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (ticketId != null) {
            parameters.put("openid.mode", "id_res");
            parameters.put("openid.identity", this.identity);
            parameters.put("openid.assoc_handle", ticketId);
            parameters.put(CONST_PARAM_SERVICE, this.getOriginalUrl());
            parameters.put("openid.signed", "identity,return_to");
            parameters.put("openid.sig", this.generateHash("identity=" + this.identity + ",return_to=" + this.getOriginalUrl()));
        } else {
            parameters.put("openid.mode", "cancel");
        }
        return Response.getRedirectResponse((String)this.getOriginalUrl(), parameters);
    }

    public boolean logOutOfService(String sessionIdentifier) {
        return false;
    }

    public static OpenIdService createServiceFrom(HttpServletRequest request) {
        String service = request.getParameter(CONST_PARAM_SERVICE);
        String openIdIdentity = request.getParameter("openid.identity");
        String signature = request.getParameter("openid.sig");
        if (openIdIdentity == null || !StringUtils.hasText((String)service)) {
            return null;
        }
        String id = OpenIdService.cleanupUrl((String)service);
        String artifactId = request.getParameter("openid.assoc_handle");
        return new OpenIdService(id, service, artifactId, openIdIdentity, signature);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.identity == null ? 0 : this.identity.hashCode());
        result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        OpenIdService other = (OpenIdService)((Object)obj);
        return !(this.identity == null ? other.identity != null : !this.identity.equals(other.identity));
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getSignature() {
        return this.signature != null ? this.signature : this.generateHash("identity=" + this.identity + ",return_to=" + this.getOriginalUrl());
    }
}

