/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.support.saml.util.SamlCompliantUniqueTicketIdGenerator$AjcClosure1;
import org.jasig.cas.ticket.UniqueTicketIdGenerator;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactType0001;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="samlServiceTicketUniqueIdGenerator")
public final class SamlCompliantUniqueTicketIdGenerator
implements UniqueTicketIdGenerator {
    private static final int ASSERTION_HANDLE_SIZE = 20;
    private static final byte[] ENDPOINT_ID;
    private final byte[] sourceIdDigest;
    @Value(value="${cas.saml.ticketid.saml2:false}")
    private boolean saml2compliant;
    private final SecureRandom random;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        SamlCompliantUniqueTicketIdGenerator.ajc$preClinit();
        byte[] byArray = new byte[2];
        byArray[1] = 1;
        ENDPOINT_ID = byArray;
    }

    @Autowired
    public SamlCompliantUniqueTicketIdGenerator(@Value(value="${server.name}") String sourceId) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(sourceId.getBytes("8859_1"));
            this.sourceIdDigest = messageDigest.digest();
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception generating digest of source ID.", e);
        }
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Cannot get SHA1PRNG secure random instance.");
        }
    }

    public String getNewTicketId(String prefix) {
        String string = prefix;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new SamlCompliantUniqueTicketIdGenerator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setSaml2compliant(boolean saml2compliant) {
        this.saml2compliant = saml2compliant;
    }

    private byte[] newAssertionHandle() {
        byte[] handle = new byte[20];
        this.random.nextBytes(handle);
        return handle;
    }

    static final /* synthetic */ String getNewTicketId_aroundBody0(SamlCompliantUniqueTicketIdGenerator ajc$this, String prefix, JoinPoint joinPoint) {
        if (ajc$this.saml2compliant) {
            return new SAML2ArtifactType0004(ENDPOINT_ID, ajc$this.newAssertionHandle(), ajc$this.sourceIdDigest).base64Encode();
        }
        return new SAML1ArtifactType0001(ajc$this.sourceIdDigest, ajc$this.newAssertionHandle()).base64Encode();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SamlCompliantUniqueTicketIdGenerator.java", SamlCompliantUniqueTicketIdGenerator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNewTicketId", "org.jasig.cas.support.saml.util.SamlCompliantUniqueTicketIdGenerator", "java.lang.String", "prefix", "", "java.lang.String"), 68);
    }
}

