/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.web.view;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.principal.ServiceFactory;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.web.view.AbstractCasView;
import org.jasig.cas.support.saml.authentication.principal.SamlServiceFactory;
import org.jasig.cas.support.saml.util.Saml10ObjectBuilder;
import org.jasig.cas.web.support.ArgumentExtractor;
import org.jasig.cas.web.support.DefaultArgumentExtractor;
import org.joda.time.DateTime;
import org.opensaml.saml.saml1.core.Response;

public abstract class AbstractSaml10ResponseView
extends AbstractCasView {
    private static final String DEFAULT_ENCODING = "UTF-8";
    protected final Saml10ObjectBuilder samlObjectBuilder = new Saml10ObjectBuilder();
    private final ArgumentExtractor samlArgumentExtractor = new DefaultArgumentExtractor((ServiceFactory)new SamlServiceFactory());
    @NotNull
    private String encoding = "UTF-8";
    private int skewAllowance;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSkewAllowance(int skewAllowance) {
        this.logger.debug("Using {} seconds as skew allowance.", (Object)skewAllowance);
        this.skewAllowance = skewAllowance;
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String serviceId = null;
        try {
            response.setCharacterEncoding(this.encoding);
            WebApplicationService service = this.samlArgumentExtractor.extractService(request);
            if (service == null || StringUtils.isBlank((CharSequence)service.getId())) {
                serviceId = "UNKNOWN";
            } else {
                try {
                    serviceId = new URL(service.getId()).getHost();
                }
                catch (MalformedURLException e) {
                    this.logger.debug(e.getMessage(), (Throwable)e);
                }
            }
            this.logger.debug("Using {} as the recipient of the SAML response for {}", (Object)serviceId, (Object)service);
            Response samlResponse = this.samlObjectBuilder.newResponse(this.samlObjectBuilder.generateSecureRandomId(), DateTime.now().minusSeconds(this.skewAllowance), serviceId, service);
            this.prepareResponse(samlResponse, model);
            this.samlObjectBuilder.encodeSamlResponse(response, request, samlResponse);
        }
        catch (Exception e) {
            this.logger.error("Error generating SAML response for service {}.", serviceId, (Object)e);
            throw e;
        }
    }

    protected abstract void prepareResponse(Response var1, Map<String, Object> var2);
}

