/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.x509.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.adaptors.x509.authentication.handler.support.DenyRevocationPolicy;
import org.jasig.cas.adaptors.x509.authentication.handler.support.RevocationChecker;
import org.jasig.cas.adaptors.x509.authentication.handler.support.RevocationPolicy;
import org.jasig.cas.adaptors.x509.authentication.handler.support.RevokedCertificateException;
import org.jasig.cas.adaptors.x509.authentication.handler.support.ThresholdExpiredCRLRevocationPolicy;
import org.jasig.cas.adaptors.x509.util.CertUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCRLRevocationChecker
implements RevocationChecker {
    protected final Log log = LogFactory.getLog(this.getClass());
    @NotNull
    private RevocationPolicy<Void> unavailableCRLPolicy = new DenyRevocationPolicy();
    @NotNull
    private RevocationPolicy<X509CRL> expiredCRLPolicy = new ThresholdExpiredCRLRevocationPolicy();

    @Override
    public void check(X509Certificate cert) throws GeneralSecurityException {
        X509CRLEntry entry;
        X509CRL crl;
        if (cert == null) {
            throw new IllegalArgumentException("Certificate cannot be null.");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Evaluating certificate revocation status for " + CertUtils.toString(cert)));
        }
        if ((crl = this.getCRL(cert)) == null) {
            this.log.warn((Object)("CRL data is not available for " + CertUtils.toString(cert)));
            this.unavailableCRLPolicy.apply(null);
            return;
        }
        if (CertUtils.isExpired(crl)) {
            this.log.warn((Object)("CRL data expired on " + crl.getNextUpdate()));
            this.expiredCRLPolicy.apply(crl);
        }
        if ((entry = crl.getRevokedCertificate(cert)) != null) {
            throw new RevokedCertificateException(entry);
        }
    }

    public void setUnavailableCRLPolicy(RevocationPolicy<Void> policy) {
        this.unavailableCRLPolicy = policy;
    }

    public void setExpiredCRLPolicy(RevocationPolicy<X509CRL> policy) {
        this.expiredCRLPolicy = policy;
    }

    protected abstract X509CRL getCRL(X509Certificate var1);
}

