/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.x509.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.Date;

public class ExpiredCRLException
extends GeneralSecurityException {
    private static final long serialVersionUID = 5157864033250359972L;
    private String id;
    private Date expirationDate;
    private int leniency;

    public ExpiredCRLException(String identifier, Date expirationDate) {
        this(identifier, expirationDate, 0);
    }

    public ExpiredCRLException(String identifier, Date expirationDate, int leniency) {
        this.id = identifier;
        this.expirationDate = expirationDate;
        if (leniency < 0) {
            throw new IllegalArgumentException("Leniency cannot be negative.");
        }
        this.leniency = leniency;
    }

    public String getId() {
        return this.id;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public int getLeniency() {
        return this.leniency;
    }

    @Override
    public String getMessage() {
        if (this.leniency > 0) {
            return String.format("CRL %s expired on %s and is beyond the leniency period of %s seconds.", this.id, this.expirationDate, this.leniency);
        }
        return String.format("CRL %s expired on %s", this.id, this.expirationDate);
    }
}

