/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.x509.web.flow;

import java.security.cert.X509Certificate;
import org.jasig.cas.adaptors.x509.authentication.principal.X509CertificateCredentials;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.web.flow.AbstractNonInteractiveCredentialsAction;
import org.springframework.webflow.execution.RequestContext;

public final class X509CertificateCredentialsNonInteractiveAction
extends AbstractNonInteractiveCredentialsAction {
    private static final String CERTIFICATE_REQUEST_ATTRIBUTE = "javax.servlet.request.X509Certificate";

    protected Credentials constructCredentialsFromRequest(RequestContext context) {
        X509Certificate[] certificates = (X509Certificate[])context.getExternalContext().getRequestMap().get(CERTIFICATE_REQUEST_ATTRIBUTE);
        if (certificates == null || certificates.length == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Certificates not found in request.");
            }
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Certificate found in request.");
        }
        return new X509CertificateCredentials(certificates);
    }
}

