/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.x509.authentication.handler.support;

import edu.vt.middleware.crypt.x509.ExtensionReader;
import edu.vt.middleware.crypt.x509.types.DistributionPoint;
import edu.vt.middleware.crypt.x509.types.DistributionPointList;
import edu.vt.middleware.crypt.x509.types.GeneralName;
import edu.vt.middleware.crypt.x509.types.GeneralNameList;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.jasig.cas.adaptors.x509.authentication.handler.support.AbstractCRLRevocationChecker;
import org.jasig.cas.adaptors.x509.util.CertUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class CRLDistributionPointRevocationChecker
extends AbstractCRLRevocationChecker {
    private final Cache crlCache;

    public CRLDistributionPointRevocationChecker(Cache crlCache) {
        if (crlCache == null) {
            throw new IllegalArgumentException("Cache cannot be null.");
        }
        this.crlCache = crlCache;
    }

    @Override
    protected X509CRL getCRL(X509Certificate cert) {
        URL[] urls = this.getDistributionPoints(cert);
        this.logger.debug(String.format("Distribution points for %s: %s.", CertUtils.toString(cert), Arrays.asList(urls)));
        for (URL url : urls) {
            Element item = this.crlCache.get((Serializable)url);
            if (item == null) continue;
            this.logger.debug("Found CRL in cache for {}", (Object)CertUtils.toString(cert));
            return (X509CRL)item.getObjectValue();
        }
        X509CRL crl = null;
        for (int i = 0; i < urls.length && crl == null; ++i) {
            this.logger.info("Attempting to fetch CRL at {}", (Object)urls[i]);
            try {
                crl = CertUtils.fetchCRL((Resource)new UrlResource(urls[i]));
                this.logger.info("Success. Caching fetched CRL.");
                this.crlCache.put(new Element((Object)urls[i], (Object)crl));
                continue;
            }
            catch (Exception e) {
                this.logger.error("Error fetching CRL at {}", (Object)urls[i], (Object)e);
            }
        }
        return crl;
    }

    private URL[] getDistributionPoints(X509Certificate cert) {
        DistributionPointList points;
        try {
            points = new ExtensionReader(cert).readCRLDistributionPoints();
        }
        catch (Exception e) {
            this.logger.error("Error reading CRLDistributionPoints extension field on " + CertUtils.toString(cert), (Throwable)e);
            return new URL[0];
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (DistributionPoint point : (DistributionPoint[])points.getItems()) {
            Object location = point.getDistributionPoint();
            if (location instanceof String) {
                this.addURL(urls, (String)location);
                continue;
            }
            if (location instanceof GeneralNameList) {
                for (GeneralName gn : (GeneralName[])((GeneralNameList)location).getItems()) {
                    this.addURL(urls, gn.getName());
                }
                continue;
            }
            this.logger.warn("{} not supported. String or GeneralNameList expected.", location);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private void addURL(List<URL> list, String uriString) {
        try {
            URL url = new URL(uriString);
            URI uri = new URI(url.getProtocol(), url.getAuthority(), url.getPath(), url.getQuery(), null);
            list.add(uri.toURL());
        }
        catch (Exception e) {
            this.logger.warn("{} is not a valid distribution point URI.", (Object)uriString);
        }
    }
}

