/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.logout.LogoutRequest;
import org.jasig.cas.logout.LogoutRequestStatus;
import org.jasig.cas.web.flow.AbstractLogoutAction;
import org.jasig.cas.web.flow.FrontChannelLogoutAction$AjcClosure1;
import org.jasig.cas.web.support.WebUtils;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public final class FrontChannelLogoutAction
extends AbstractLogoutAction {
    public static final String DEFAULT_LOGOUT_PARAMETER = "SAMLRequest";
    public static final String DEFAULT_FLOW_ATTRIBUTE_LOGOUT_URL = "logoutUrl";
    private static final Logger LOGGER;
    private String logoutRequestParameter = "SAMLRequest";
    @NotNull
    private final LogoutManager logoutManager;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public FrontChannelLogoutAction(LogoutManager logoutManager) {
        this.logoutManager = logoutManager;
    }

    @Override
    protected Event doInternalExecute(HttpServletRequest request, HttpServletResponse response, RequestContext context) throws Exception {
        List logoutRequests = WebUtils.getLogoutRequests((RequestContext)context);
        Integer startIndex = this.getLogoutIndex(context);
        if (logoutRequests != null) {
            for (int i = startIndex.intValue(); i < logoutRequests.size(); ++i) {
                LogoutRequest logoutRequest = (LogoutRequest)logoutRequests.get(i);
                if (logoutRequest.getStatus() != LogoutRequestStatus.NOT_ATTEMPTED) continue;
                logoutRequest.setStatus(LogoutRequestStatus.SUCCESS);
                this.putLogoutIndex(context, i + 1);
                String logoutUrl = logoutRequest.getLogoutUrl().toExternalForm();
                LOGGER.debug("Using logout url [{}] for front-channel logout requests", (Object)logoutUrl);
                String logoutMessage = this.logoutManager.createFrontChannelLogoutMessage(logoutRequest);
                LOGGER.debug("Front-channel logout message to send under [{}] is [{}]", (Object)this.logoutRequestParameter, (Object)logoutMessage);
                UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)logoutUrl);
                builder.queryParam(this.logoutRequestParameter, new Object[]{URLEncoder.encode(logoutMessage, "UTF-8")});
                return this.result("redirectApp", DEFAULT_FLOW_ATTRIBUTE_LOGOUT_URL, builder.build().toUriString());
            }
        }
        return new Event((Object)this, "finish");
    }

    public LogoutManager getLogoutManager() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (LogoutManager)TraceLogAspect.aspectOf().traceMethod(new FrontChannelLogoutAction$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setLogoutRequestParameter(String logoutRequestParameter) {
        this.logoutRequestParameter = logoutRequestParameter;
    }

    static {
        FrontChannelLogoutAction.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(FrontChannelLogoutAction.class);
    }

    static final /* synthetic */ LogoutManager getLogoutManager_aroundBody0(FrontChannelLogoutAction ajc$this, JoinPoint joinPoint) {
        return ajc$this.logoutManager;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FrontChannelLogoutAction.java", FrontChannelLogoutAction.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLogoutManager", "org.jasig.cas.web.flow.FrontChannelLogoutAction", "", "", "", "org.jasig.cas.logout.LogoutManager"), 104);
    }
}

