/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter$AjcClosure1;
import org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter$AjcClosure3;
import org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter$AjcClosure5;
import org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter$AjcClosure7;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractThrottledSubmissionHandlerInterceptorAdapter
extends HandlerInterceptorAdapter
implements InitializingBean {
    private static final int DEFAULT_FAILURE_THRESHOLD = 100;
    private static final int DEFAULT_FAILURE_RANGE_IN_SECONDS = 60;
    private static final String DEFAULT_USERNAME_PARAMETER = "username";
    private static final String SUCCESSFUL_AUTHENTICATION_EVENT = "success";
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Min(value=0L)
    private int failureThreshold = 100;
    @Min(value=0L)
    private int failureRangeInSeconds = 60;
    @NotNull
    private String usernameParameter = "username";
    private double thresholdRate;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public void afterPropertiesSet() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new AbstractThrottledSubmissionHandlerInterceptorAdapter$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public final boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
        HttpServletRequest httpServletRequest = request;
        HttpServletResponse httpServletResponse = response;
        Object object = o;
        Object[] objectArray = new Object[]{httpServletRequest, httpServletResponse, object};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, httpServletRequest, httpServletResponse, object, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new AbstractThrottledSubmissionHandlerInterceptorAdapter$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648)));
    }

    public final void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) throws Exception {
        HttpServletRequest httpServletRequest = request;
        HttpServletResponse httpServletResponse = response;
        Object object = o;
        ModelAndView modelAndView2 = modelAndView;
        Object[] objectArray = new Object[]{httpServletRequest, httpServletResponse, object, modelAndView2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, httpServletRequest, httpServletResponse, object, modelAndView2, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new AbstractThrottledSubmissionHandlerInterceptorAdapter$AjcClosure5(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public final void setFailureThreshold(int failureThreshold) {
        this.failureThreshold = failureThreshold;
    }

    public final void setFailureRangeInSeconds(int failureRangeInSeconds) {
        this.failureRangeInSeconds = failureRangeInSeconds;
    }

    public final void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    protected double getThresholdRate() {
        return this.thresholdRate;
    }

    protected int getFailureThreshold() {
        return this.failureThreshold;
    }

    protected int getFailureRangeInSeconds() {
        return this.failureRangeInSeconds;
    }

    protected String getUsernameParameter() {
        return this.usernameParameter;
    }

    protected void recordThrottle(HttpServletRequest request) {
        this.logger.warn("Throttling submission from {}.  More than {} failed login attempts within {} seconds. Authentication attempt exceeds the failure threshold {}", new Object[]{request.getRemoteAddr(), this.failureThreshold, this.failureRangeInSeconds, this.failureThreshold});
    }

    protected abstract void recordSubmissionFailure(HttpServletRequest var1);

    protected abstract boolean exceedsThreshold(HttpServletRequest var1);

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new AbstractThrottledSubmissionHandlerInterceptorAdapter$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    static {
        AbstractThrottledSubmissionHandlerInterceptorAdapter.ajc$preClinit();
    }

    static final /* synthetic */ void afterPropertiesSet_aroundBody0(AbstractThrottledSubmissionHandlerInterceptorAdapter ajc$this, JoinPoint joinPoint) {
        ajc$this.thresholdRate = (double)ajc$this.failureThreshold / (double)ajc$this.failureRangeInSeconds;
    }

    static final /* synthetic */ boolean preHandle_aroundBody2(AbstractThrottledSubmissionHandlerInterceptorAdapter ajc$this, HttpServletRequest request, HttpServletResponse response, Object o, JoinPoint joinPoint) {
        if (!"POST".equals(request.getMethod())) {
            return true;
        }
        if (ajc$this.exceedsThreshold(request)) {
            ajc$this.recordThrottle(request);
            request.setAttribute("CAS_ACCESS_DENIED_REASON", (Object)"screen.blocked.message");
            response.sendError(403, "Access Denied for user [" + request.getParameter(ajc$this.usernameParameter) + "] from IP Address [" + request.getRemoteAddr() + ']');
            return false;
        }
        return true;
    }

    static final /* synthetic */ void postHandle_aroundBody4(AbstractThrottledSubmissionHandlerInterceptorAdapter ajc$this, HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView, JoinPoint joinPoint) {
        if (!"POST".equals(request.getMethod())) {
            return;
        }
        RequestContext context = (RequestContext)request.getAttribute("flowRequestContext");
        if (context == null || context.getCurrentEvent() == null) {
            return;
        }
        if (SUCCESSFUL_AUTHENTICATION_EVENT.equals(context.getCurrentEvent().getId())) {
            return;
        }
        ajc$this.recordSubmissionFailure(request);
    }

    static final /* synthetic */ String toString_aroundBody6(AbstractThrottledSubmissionHandlerInterceptorAdapter ajc$this, JoinPoint joinPoint) {
        return new ToStringBuilder((Object)ajc$this).append("failureThreshold", ajc$this.failureThreshold).append("failureRangeInSeconds", ajc$this.failureRangeInSeconds).append("usernameParameter", (Object)ajc$this.usernameParameter).append("thresholdRate", ajc$this.thresholdRate).toString();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractThrottledSubmissionHandlerInterceptorAdapter.java", AbstractThrottledSubmissionHandlerInterceptorAdapter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "afterPropertiesSet", "org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter", "", "", "java.lang.Exception", "void"), 68);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "preHandle", "org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter", "javax.servlet.http.HttpServletRequest:javax.servlet.http.HttpServletResponse:java.lang.Object", "request:response:o", "java.lang.Exception", "boolean"), 75);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "postHandle", "org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter", "javax.servlet.http.HttpServletRequest:javax.servlet.http.HttpServletResponse:java.lang.Object:org.springframework.web.servlet.ModelAndView", "request:response:o:modelAndView", "java.lang.Exception", "void"), 94);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter", "", "", "", "java.lang.String"), 171);
    }
}

