/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import javax.validation.constraints.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public final class GenerateServiceTicketAction
extends AbstractAction {
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;

    protected Event doExecute(RequestContext context) {
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        String ticketGrantingTicket = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        try {
            ServiceTicket serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicket, (Service)service);
            WebUtils.putServiceTicketInRequestScope((RequestContext)context, (ServiceTicket)serviceTicketId);
            return this.success();
        }
        catch (TicketException e) {
            if (e instanceof InvalidTicketException) {
                this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicket);
            }
            if (this.isGatewayPresent(context)) {
                return this.result("gateway");
            }
            return this.newEvent("error", (Exception)((Object)e));
        }
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    protected boolean isGatewayPresent(RequestContext context) {
        return StringUtils.hasText((String)context.getExternalContext().getRequestParameterMap().get("gateway"));
    }

    private Event newEvent(String id, Exception error) {
        return new Event((Object)this, id, (AttributeMap)new LocalAttributeMap("error", (Object)error));
    }
}

