/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.validation.constraints.NotNull;
import org.jasig.cas.web.flow.CasFlowExecutionKey;
import org.springframework.util.StringUtils;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationException;
import org.springframework.webflow.conversation.ConversationId;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.conversation.ConversationParameters;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.repository.BadlyFormattedFlowExecutionKeyException;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryException;
import org.springframework.webflow.execution.repository.impl.DefaultFlowExecutionRepository;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshotFactory;
import org.springframework.webflow.execution.repository.support.CompositeFlowExecutionKey;

/*
 * Exception performing whole class analysis ignored.
 */
public final class CasFlowExecutionKeyFactory
extends DefaultFlowExecutionRepository {
    public static final String DEFAULT_ENCRYPTION_ALGORITHM = "AES";
    public static final String DEFAULT_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private boolean defaultBehavior = false;
    @NotNull
    private final ConversationManager conversationManager;
    @NotNull
    private final Key key;
    @NotNull
    private final String cipherAlgorithm;
    private final byte[] initialVector = CasFlowExecutionKeyFactory.getRandomSalt((int)16);
    private final IvParameterSpec ivs = new IvParameterSpec(this.initialVector);

    public CasFlowExecutionKeyFactory(ConversationManager conversationManager, FlowExecutionSnapshotFactory snapshotFactory) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        this(conversationManager, snapshotFactory, "AES/CBC/PKCS5Padding", (Key)KeyGenerator.getInstance("AES").generateKey());
    }

    public CasFlowExecutionKeyFactory(ConversationManager conversationManager, FlowExecutionSnapshotFactory snapshotFactory, String cipherAlgorithm, Key secretKey) {
        super(conversationManager, snapshotFactory);
        this.conversationManager = conversationManager;
        this.key = secretKey;
        this.cipherAlgorithm = cipherAlgorithm;
    }

    private static byte[] getRandomSalt(int size) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] bytes = new byte[size];
        secureRandom.nextBytes(bytes);
        return bytes;
    }

    protected String decrypt(String value) {
        if (value == null) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
            cipher.init(2, this.key, this.ivs);
            return new String(cipher.doFinal(CasFlowExecutionKeyFactory.hexStringToByteArray((String)value)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String encrypt(String value) {
        if (value == null) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
            cipher.init(1, this.key, this.ivs);
            return CasFlowExecutionKeyFactory.byteArrayToHexString((byte[])cipher.doFinal(value.getBytes()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        int i = 0;
        while (i < b.length) {
            int v = b[i] & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
            ++i;
        }
        return sb.toString().toUpperCase();
    }

    protected static byte[] hexStringToByteArray(String s) {
        byte[] b = new byte[s.length() / 2];
        int i = 0;
        while (i < b.length) {
            int index = i * 2;
            int v = Integer.parseInt(s.substring(index, index + 2), 16);
            b[i] = (byte)v;
            ++i;
        }
        return b;
    }

    public FlowExecutionKey getKey(FlowExecution execution) {
        if (this.defaultBehavior) {
            return super.getKey(execution);
        }
        CasFlowExecutionKey key = (CasFlowExecutionKey)execution.getKey();
        if (key == null) {
            Conversation conversation = this.beginConversation(execution);
            ConversationId executionId = conversation.getId();
            Serializable nextSnapshotId = this.nextSnapshotId((Serializable)executionId);
            String unencryptedVersion = String.valueOf(UUID.randomUUID().toString()) + "Z" + "e" + executionId + "s" + nextSnapshotId;
            String encryptedVersion = this.encrypt(unencryptedVersion);
            return new CasFlowExecutionKey((Serializable)executionId, nextSnapshotId, encryptedVersion);
        }
        if (this.getAlwaysGenerateNewNextKey()) {
            Serializable executionId = key.getExecutionId();
            Serializable snapshotId = this.nextSnapshotId(key.getExecutionId());
            String unencryptedVersion = String.valueOf(UUID.randomUUID().toString()) + "Z" + "e" + executionId + "s" + snapshotId;
            String encryptedVersion = this.encrypt(unencryptedVersion);
            return new CasFlowExecutionKey(executionId, snapshotId, encryptedVersion);
        }
        return execution.getKey();
    }

    public FlowExecutionKey parseFlowExecutionKey(String encodedKey) throws FlowExecutionRepositoryException {
        if (this.defaultBehavior) {
            return super.parseFlowExecutionKey(encodedKey);
        }
        if (!StringUtils.hasText((String)encodedKey)) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, "The string-encoded flow execution key is required");
        }
        String unencryptedVersion = this.decrypt(encodedKey);
        String[] keyParts = CasFlowExecutionKey.keyParts((String)unencryptedVersion);
        ConversationId executionId = this.parseExecutionId(keyParts[0], encodedKey);
        Serializable snapshotId = this.parseSnapshotId(keyParts[1], encodedKey);
        return new CasFlowExecutionKey((Serializable)executionId, snapshotId, encodedKey);
    }

    private ConversationId parseExecutionId(String encodedId, String encodedKey) throws BadlyFormattedFlowExecutionKeyException {
        try {
            return this.conversationManager.parseConversationId(encodedId);
        }
        catch (ConversationException e) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, CompositeFlowExecutionKey.getFormat(), (Throwable)e);
        }
    }

    private Serializable parseSnapshotId(String encodedId, String encodedKey) throws BadlyFormattedFlowExecutionKeyException {
        try {
            return Integer.valueOf(encodedId);
        }
        catch (NumberFormatException e) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, CompositeFlowExecutionKey.getFormat(), (Throwable)e);
        }
    }

    private Conversation beginConversation(FlowExecution execution) {
        ConversationParameters parameters = this.createConversationParameters(execution);
        Conversation conversation = this.conversationManager.beginConversation(parameters);
        return conversation;
    }

    public void setDefaultBehavior(boolean defaultBehavior) {
        this.defaultBehavior = defaultBehavior;
    }
}

