/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jgroups;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.distribution.jgroups.JGroupEventMessage;
import net.sf.ehcache.distribution.jgroups.JGroupsBootstrapManager;
import net.sf.ehcache.distribution.jgroups.jmx.JGroupsCacheReceiverStats;
import net.sf.ehcache.distribution.jgroups.jmx.JGroupsCacheReceiverStatsCounter;
import net.sf.ehcache.distribution.jgroups.jmx.NullJGroupsCacheReceiverStats;
import net.sf.ehcache.util.CacheTransactionHelper;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsCacheReceiver
implements Receiver {
    private static final Logger LOG = LoggerFactory.getLogger((String)JGroupsCacheReceiver.class.getName());
    private final CacheManager cacheManager;
    private final JGroupsBootstrapManager bootstrapManager;
    private MBeanServer mBeanServer;
    private ObjectName objectName;
    private JGroupsCacheReceiverStatsCounter cacheReceiverStats = new NullJGroupsCacheReceiverStats();

    public JGroupsCacheReceiver(CacheManager cacheManager, JGroupsBootstrapManager bootstrapManager) {
        this.cacheManager = cacheManager;
        this.bootstrapManager = bootstrapManager;
    }

    public void register(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
        this.cacheReceiverStats = new JGroupsCacheReceiverStats();
        try {
            this.objectName = ObjectName.getInstance("net.sf.ehcache:type=JGroupsStatistics,CacheManager=" + this.cacheManager.getName() + ",name=JGroupsCacheReceiver");
            this.mBeanServer.registerMBean(this.cacheReceiverStats, this.objectName);
            LOG.debug("Registered JGroups Cache Receiver with MBeanServer under {}", (Object)this.objectName);
        }
        catch (Exception e) {
            LOG.error("Error occured while registering JGroupsCacheReceiver MBean. JGroupsCacheReceiver Statistics will not be enabled.", (Throwable)e);
        }
    }

    public void dispose() {
        if (this.mBeanServer != null) {
            try {
                this.mBeanServer.unregisterMBean(this.objectName);
            }
            catch (Exception e) {
                LOG.error("Error occured while unregistering JGroupsCacheReceiver MBean. " + this.objectName, (Throwable)e);
            }
        }
    }

    public void receive(Message msg) {
        if (msg == null || msg.getLength() == 0) {
            LOG.warn("Recieved an empty or null Message: {}", (Object)msg);
            return;
        }
        Object object = msg.getObject();
        if (object == null) {
            LOG.warn("Recieved a Message with a null object: {}", (Object)msg);
            return;
        }
        if (object instanceof JGroupEventMessage) {
            this.safeHandleJGroupNotification((JGroupEventMessage)((Object)object));
        } else if (object instanceof List) {
            List messages = (List)object;
            LOG.trace("Recieved List of {} JGroupEventMessages", (Object)messages.size());
            for (Object message : messages) {
                if (message == null) continue;
                if (message instanceof JGroupEventMessage) {
                    this.safeHandleJGroupNotification((JGroupEventMessage)((Object)message));
                    continue;
                }
                LOG.warn("Recieved message of type " + List.class + " but member was of type '" + message.getClass() + "' and not " + JGroupEventMessage.class + ". Member ignored: " + message);
            }
        } else {
            LOG.warn("Recieved message with payload of type " + object.getClass() + " and not " + JGroupEventMessage.class + " or List<" + JGroupEventMessage.class.getSimpleName() + ">. Message: " + msg + " payload " + object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeHandleJGroupNotification(JGroupEventMessage message) {
        boolean started;
        String cacheName = message.getCacheName();
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        boolean bl = started = cache != null && CacheTransactionHelper.isTransactionStarted((Ehcache)cache);
        if (cache != null && !started) {
            CacheTransactionHelper.beginTransactionIfNeeded((Ehcache)cache);
        }
        try {
            this.handleJGroupNotification(message);
        }
        catch (Exception e) {
            LOG.error("Failed to handle message " + (Object)((Object)message), (Throwable)e);
        }
        finally {
            if (cache != null && !started) {
                CacheTransactionHelper.commitTransactionIfNeeded((Ehcache)cache);
            }
        }
    }

    private void handleJGroupNotification(JGroupEventMessage message) {
        String cacheName = message.getCacheName();
        switch (message.getEvent()) {
            case 10: {
                this.cacheReceiverStats.countBootstrapRequest();
                LOG.debug("received bootstrap request:    from {} for cache={}", (Object)message.getSerializableKey(), (Object)cacheName);
                this.bootstrapManager.sendBootstrapResponse(message);
                break;
            }
            case 12: {
                this.cacheReceiverStats.countBootstrapComplete();
                LOG.debug("received bootstrap complete:   cache={}", (Object)cacheName);
                this.bootstrapManager.handleBootstrapComplete(message);
                break;
            }
            case 13: {
                this.cacheReceiverStats.countBootstrapIncomplete();
                LOG.debug("received bootstrap incomplete: cache={}", (Object)cacheName);
                this.bootstrapManager.handleBootstrapIncomplete(message);
                break;
            }
            case 11: {
                this.cacheReceiverStats.countBootstrapResponse();
                Serializable serializableKey = message.getSerializableKey();
                LOG.debug("received bootstrap reply:      cache={}, key={}", (Object)cacheName, (Object)serializableKey);
                this.bootstrapManager.handleBootstrapResponse(message);
                break;
            }
            default: {
                this.handleEhcacheNotification(message, cacheName);
            }
        }
    }

    private void handleEhcacheNotification(JGroupEventMessage message, String cacheName) {
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache == null) {
            LOG.warn("Received message {} for cache that does not exist: {}", (Object)message, (Object)cacheName);
            return;
        }
        switch (message.getEvent()) {
            case 3: {
                this.cacheReceiverStats.countRemoveAll();
                LOG.debug("received remove all:      cache={}", (Object)cacheName);
                cache.removeAll(true);
                break;
            }
            case 1: {
                Serializable serializableKey = message.getSerializableKey();
                if (cache.getQuiet(serializableKey) != null) {
                    this.cacheReceiverStats.countRemoveExisting();
                    LOG.debug("received remove:          cache={}, key={}", (Object)cacheName, (Object)serializableKey);
                    cache.remove(serializableKey, true);
                    break;
                }
                if (!LOG.isTraceEnabled()) break;
                this.cacheReceiverStats.countRemoveNotExisting();
                LOG.trace("received remove:          cache={}, key={} - Ignoring, key is not in the local cache.", (Object)cacheName, (Object)serializableKey);
                break;
            }
            case 0: {
                this.cacheReceiverStats.countPut();
                Serializable serializableKey = message.getSerializableKey();
                LOG.debug("received put:             cache={}, key={}", (Object)cacheName, (Object)serializableKey);
                cache.put(message.getElement(), true);
                break;
            }
            default: {
                LOG.warn("Unknown JGroupsEventMessage type recieved, ignoring message: " + (Object)((Object)message));
            }
        }
    }

    public void getState(OutputStream output) {
    }

    public void setState(InputStream input) {
    }

    public void block() {
    }

    public void unblock() {
    }

    public void suspect(Address suspectedMbr) {
    }

    public void viewAccepted(View newView) {
    }
}

