/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.inspektr.audit.support;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.jasig.inspektr.audit.AuditActionContext;
import org.jasig.inspektr.audit.AuditTrailManager;
import org.jasig.inspektr.audit.support.NoMatchWhereClauseMatchCriteria;
import org.jasig.inspektr.audit.support.WhereClauseMatchCriteria;
import org.jasig.inspektr.common.Cleanable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcDaoSupport;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class JdbcAuditTrailManager
extends NamedParameterJdbcDaoSupport
implements AuditTrailManager,
Cleanable,
DisposableBean {
    private static final String INSERT_SQL_TEMPLATE = "INSERT INTO %s (AUD_USER, AUD_CLIENT_IP, AUD_SERVER_IP, AUD_RESOURCE, AUD_ACTION, APPLIC_CD, AUD_DATE) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String DELETE_SQL_TEMPLATE = "DELETE FROM %s %s";
    private static final int DEFAULT_COLUMN_LENGTH = 100;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private final TransactionTemplate transactionTemplate;
    @NotNull
    @Size(min=1)
    private String tableName = "COM_AUDIT_TRAIL";
    @Min(value=50L)
    private int columnLength = 100;
    @NotNull
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private boolean defaultExecutorService = true;
    private WhereClauseMatchCriteria cleanupCriteria = new NoMatchWhereClauseMatchCriteria();

    public JdbcAuditTrailManager(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void record(AuditActionContext auditActionContext) {
        this.executorService.execute(new LoggingTask(auditActionContext, this.transactionTemplate, this.columnLength));
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setCleanupCriteria(WhereClauseMatchCriteria criteria) {
        this.cleanupCriteria = criteria;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        this.defaultExecutorService = false;
    }

    public void setColumnLength(int columnLength) {
        this.columnLength = columnLength;
    }

    public void destroy() throws Exception {
        if (this.defaultExecutorService) {
            this.executorService.shutdown();
        }
    }

    public void clean() {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                String sql = String.format(JdbcAuditTrailManager.DELETE_SQL_TEMPLATE, JdbcAuditTrailManager.this.tableName, JdbcAuditTrailManager.this.cleanupCriteria);
                List<?> params = JdbcAuditTrailManager.this.cleanupCriteria.getParameterValues();
                JdbcAuditTrailManager.this.logger.info("Cleaning audit records with query " + sql);
                JdbcAuditTrailManager.this.logger.debug("Query parameters: " + params);
                int count = JdbcAuditTrailManager.this.getJdbcTemplate().update(sql, params.toArray());
                JdbcAuditTrailManager.this.logger.info(count + " records deleted.");
            }
        });
    }

    protected class LoggingTask
    implements Runnable {
        private final AuditActionContext auditActionContext;
        private final TransactionTemplate transactionTemplate;
        private final int columnLength;

        public LoggingTask(AuditActionContext auditActionContext, TransactionTemplate transactionTemplate, int columnLength) {
            this.auditActionContext = auditActionContext;
            this.transactionTemplate = transactionTemplate;
            this.columnLength = columnLength;
        }

        @Override
        public void run() {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    String userId = LoggingTask.this.auditActionContext.getPrincipal().length() <= LoggingTask.this.columnLength ? LoggingTask.this.auditActionContext.getPrincipal() : LoggingTask.this.auditActionContext.getPrincipal().substring(0, LoggingTask.this.columnLength);
                    String resource = LoggingTask.this.auditActionContext.getResourceOperatedUpon().length() <= LoggingTask.this.columnLength ? LoggingTask.this.auditActionContext.getResourceOperatedUpon() : LoggingTask.this.auditActionContext.getResourceOperatedUpon().substring(0, LoggingTask.this.columnLength);
                    String action = LoggingTask.this.auditActionContext.getActionPerformed().length() <= LoggingTask.this.columnLength ? LoggingTask.this.auditActionContext.getActionPerformed() : LoggingTask.this.auditActionContext.getActionPerformed().substring(0, LoggingTask.this.columnLength);
                    JdbcAuditTrailManager.this.getJdbcTemplate().update(String.format(JdbcAuditTrailManager.INSERT_SQL_TEMPLATE, JdbcAuditTrailManager.this.tableName), new Object[]{userId, LoggingTask.this.auditActionContext.getClientIpAddress(), LoggingTask.this.auditActionContext.getServerIpAddress(), resource, action, LoggingTask.this.auditActionContext.getApplicationCode(), LoggingTask.this.auditActionContext.getWhenActionWasPerformed()});
                }
            });
        }
    }
}

