/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.maven.notice;

import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.collections.map.LRUMap;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.jasig.maven.notice.LicenseLookupContext;
import org.jasig.maven.notice.ResolvedLicense;
import org.jasig.maven.notice.lookup.ArtifactLicense;
import org.jasig.maven.notice.lookup.LicenseLookup;
import org.jasig.maven.notice.lookup.MappedVersion;
import org.jasig.maven.notice.lookup.VersionType;
import org.jasig.maven.notice.util.ResourceFinder;

public class LicenseLookupHelper {
    private static final Map<String, LicenseLookup> LICENSE_LOOKUP_CACHE = new LRUMap(20);
    private static final ReadWriteLock LICENSE_LOOKUP_CACHE_LOCK = new ReentrantReadWriteLock();
    private final Map<String, Map<List<MappedVersion>, ArtifactLicense>> mergedLicenseLookup = new LinkedHashMap<String, Map<List<MappedVersion>, ArtifactLicense>>();
    private final Log logger;
    private final ResourceFinder resourceFinder;

    public LicenseLookupHelper(Log logger, ResourceFinder resourceFinder, String[] licenseLookupFiles) throws MojoFailureException {
        this.logger = logger;
        this.resourceFinder = resourceFinder;
        Unmarshaller unmarshaller = LicenseLookupContext.getUnmarshaller();
        if (licenseLookupFiles == null) {
            licenseLookupFiles = new String[]{};
        }
        for (String licenseLookupFile : licenseLookupFiles) {
            LicenseLookup licenseLookup = this.loadLicenseLookup(unmarshaller, licenseLookupFile);
            for (ArtifactLicense artifactLicense : licenseLookup.getArtifact()) {
                String artifactId;
                String groupId = artifactLicense.getGroupId();
                String artifactKey = this.getArtifactKey(groupId, artifactId = artifactLicense.getArtifactId());
                Map<List<MappedVersion>, ArtifactLicense> artifactVersions = this.mergedLicenseLookup.get(artifactKey);
                if (artifactVersions == null) {
                    artifactVersions = new LinkedHashMap<List<MappedVersion>, ArtifactLicense>();
                    this.mergedLicenseLookup.put(artifactKey, artifactVersions);
                }
                List<MappedVersion> version = artifactLicense.getVersion();
                artifactVersions.put(version, artifactLicense);
                this.logger.debug((CharSequence)("Mapped " + artifactLicense + " from: " + licenseLookupFile));
            }
        }
    }

    public ResolvedLicense lookupLicenseMapping(String groupId, String artifactId, ArtifactVersion artifactVersion) {
        String artifactKey = this.getArtifactKey(groupId, artifactId);
        Map<List<MappedVersion>, ArtifactLicense> artifactVersions = this.mergedLicenseLookup.get(artifactKey);
        if (artifactVersions == null) {
            return null;
        }
        VersionType matchType = null;
        ArtifactLicense artifactLicense = null;
        for (Map.Entry<List<MappedVersion>, ArtifactLicense> versionEntry : artifactVersions.entrySet()) {
            List<MappedVersion> versions = versionEntry.getKey();
            if (matchType == null && versions.size() == 0) {
                artifactLicense = versionEntry.getValue();
            } else {
                for (MappedVersion version : versions) {
                    boolean matches;
                    if (VersionType.REGEX == matchType && VersionType.REGEX == version.getType() || !(matches = this.compareVersions(version, artifactVersion))) continue;
                    matchType = version.getType();
                    artifactLicense = versionEntry.getValue();
                    if (VersionType.STRING != matchType) continue;
                    break;
                }
            }
            if (VersionType.STRING != matchType) continue;
            break;
        }
        this.logger.debug((CharSequence)("Found " + artifactLicense + " with match " + matchType + " for: " + groupId + ":" + artifactId + ":" + artifactVersion));
        return new ResolvedLicense(matchType, artifactLicense);
    }

    protected boolean compareVersions(MappedVersion version, ArtifactVersion artifactVersion) {
        switch (version.getType()) {
            case REGEX: {
                Pattern versionPattern = Pattern.compile(version.getValue());
                return versionPattern.matcher(artifactVersion.toString()).matches();
            }
        }
        DefaultArtifactVersion mappedVersion = new DefaultArtifactVersion(version.getValue());
        return mappedVersion.equals(artifactVersion);
    }

    protected String getArtifactKey(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    protected LicenseLookup loadLicenseLookup(Unmarshaller unmarshaller, String licenseLookupFile) throws MojoFailureException {
        Lock readLock;
        URL licenseLookupUrl = this.resourceFinder.findResource(licenseLookupFile);
        LicenseLookup licenseLookup = this.loadLicenseLookup(unmarshaller, licenseLookupFile, licenseLookupUrl, readLock = LICENSE_LOOKUP_CACHE_LOCK.readLock(), false);
        if (licenseLookup != null) {
            return licenseLookup;
        }
        Lock writeLock = LICENSE_LOOKUP_CACHE_LOCK.writeLock();
        return this.loadLicenseLookup(unmarshaller, licenseLookupFile, licenseLookupUrl, writeLock, true);
    }

    /*
     * Exception decompiling
     */
    protected LicenseLookup loadLicenseLookup(Unmarshaller unmarshaller, String licenseLookupFile, URL licenseLookupUrl, Lock lock, boolean create) throws MojoFailureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

