/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jasig.i18n.translate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;

public class MessageFileService {

    protected final Log log = LogFactory.getLog(getClass());

    public Set<String> getMessageKeysFromFile(final Resource messageFile) throws IOException {
        final Set<String> keys = new HashSet<String>();

        final InputStream inputStream = messageFile.getInputStream();
        final Reader inputReader = new InputStreamReader(inputStream);
        final BufferedReader bufferedReader = new BufferedReader(inputReader);

        String line;
        while ((line = bufferedReader.readLine()) != null) {
            final String[] s = line.split("=", 2);
            if (s.length == 2) {
                keys.add(s[0]);
            }
        }

        return keys;

    }

    public Map<String,String> getMessageMapFromFile(final Resource messageFile) throws IOException {
        final Map<String, String> map = new HashMap<String, String>();

        final InputStream inputStream = messageFile.getInputStream();
        final Reader inputReader = new InputStreamReader(inputStream);
        final BufferedReader bufferedReader = new BufferedReader(inputReader);

        String line;
        while ((line = bufferedReader.readLine()) != null) {
            final String[] s = line.split("=", 2);
            if (s.length == 2) {
                map.put(s[0], s[1]);
            }
        }

        return map;

    }

    public void updateMessageFile(final Resource messageFile, final Map<String, String> messageMap) throws IOException {


        final Map<String, String> newMap = new LinkedHashMap<String, String>();

        final File file = messageFile.getFile();
        final FileReader fos = new FileReader(file);
        final Properties props = new Properties();
        props.load(fos);

        final DecimalFormat f = new DecimalFormat();
        f.applyPattern("\\u0000");


        for (final Map.Entry<String, String> message : messageMap.entrySet()) {
            if (!props.containsKey(message.getKey())) {

                final StringWriter out = new StringWriter();
                final String translated = message.getValue();

                final char[] chars = new char[translated.length()];
                translated.getChars(0, chars.length, chars, 0);
                for (final char c : chars) {
                    if (c > '\u007f') {
                        out.write("\\u");
                        out.write(UnicodeFormatter.charToHex(c));
                    } else {
                        out.write(c);
                    }
                }
                newMap.put(message.getKey(), out.toString());

                out.flush();
                out.close();

            }

        }
        final FileWriter writer = new FileWriter(file, true);
        for (final Map.Entry<String, String> message : newMap.entrySet()) {
            writer.append(message.getKey().concat("=").concat(message.getValue()).concat("\n"));
        }
        writer.close();
    }

}
