/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.i18n.translate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.i18n.translate.UnicodeFormatter;
import org.springframework.core.io.Resource;

public class MessageFileService {
    protected final Log log = LogFactory.getLog(this.getClass());

    public Set<String> getMessageKeysFromFile(Resource messageFile) throws IOException {
        String line;
        HashSet<String> keys = new HashSet<String>();
        InputStream inputStream = messageFile.getInputStream();
        InputStreamReader inputReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputReader);
        while ((line = bufferedReader.readLine()) != null) {
            String[] s = line.split("=", 2);
            if (s.length != 2) continue;
            keys.add(s[0]);
        }
        return keys;
    }

    public Map<String, String> getMessageMapFromFile(Resource messageFile) throws IOException {
        String line;
        HashMap<String, String> map = new HashMap<String, String>();
        InputStream inputStream = messageFile.getInputStream();
        InputStreamReader inputReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputReader);
        while ((line = bufferedReader.readLine()) != null) {
            String[] s = line.split("=", 2);
            if (s.length != 2) continue;
            map.put(s[0], s[1]);
        }
        return map;
    }

    public void updateMessageFile(Resource messageFile, Map<String, String> messageMap) throws IOException {
        LinkedHashMap<String, String> newMap = new LinkedHashMap<String, String>();
        File file = messageFile.getFile();
        FileReader fos = new FileReader(file);
        Properties props = new Properties();
        props.load(fos);
        DecimalFormat f = new DecimalFormat();
        f.applyPattern("\\u0000");
        for (Map.Entry<String, String> message : messageMap.entrySet()) {
            if (props.containsKey(message.getKey())) continue;
            StringWriter out = new StringWriter();
            String translated = message.getValue();
            char[] chars = new char[translated.length()];
            translated.getChars(0, chars.length, chars, 0);
            for (char c : chars) {
                if (c > '\u007f') {
                    out.write("\\u");
                    out.write(UnicodeFormatter.charToHex(c));
                    continue;
                }
                out.write(c);
            }
            newMap.put(message.getKey(), out.toString());
            out.flush();
            out.close();
        }
        FileWriter writer = new FileWriter(file, true);
        for (Map.Entry message : newMap.entrySet()) {
            writer.append(((String)message.getKey()).concat("=").concat((String)message.getValue()).concat("\n"));
        }
        writer.close();
    }
}

