/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.openregistry.test.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.jasig.openregistry.test.domain.MockActivationKey;
import org.jasig.openregistry.test.domain.MockName;
import org.jasig.openregistry.test.domain.MockRole;
import org.openregistry.core.domain.ActivationKey;
import org.openregistry.core.domain.Identifier;
import org.openregistry.core.domain.IdentifierType;
import org.openregistry.core.domain.Name;
import org.openregistry.core.domain.Person;
import org.openregistry.core.domain.Role;
import org.openregistry.core.domain.Type;
import org.openregistry.core.domain.sor.SorRole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockPerson
implements Person {
    private ActivationKey activationKey = new MockActivationKey(UUID.randomUUID().toString(), new Date(), new Date());
    private final String identifierType = "NETID";
    private final String identifierValue;
    private List<Role> roles = new ArrayList<Role>();
    private long id = 1L;

    public MockPerson() {
        this("testId", false, false);
    }

    public MockPerson(String identifierValue, boolean notActive, boolean expired) {
        Date endDate;
        Date startDate;
        this.identifierValue = identifierValue;
        if (notActive && expired) {
            throw new IllegalArgumentException("You're crazy!");
        }
        if (notActive) {
            startDate = new Date(System.currentTimeMillis() + 50000L);
            endDate = new Date(System.currentTimeMillis() + 50000000L);
        } else if (expired) {
            startDate = new Date(System.currentTimeMillis() - 500000L);
            endDate = new Date(System.currentTimeMillis() - 50000L);
        } else {
            startDate = new Date();
            endDate = new Date(System.currentTimeMillis() + 50000000L);
        }
        this.activationKey = new MockActivationKey("key", startDate, endDate);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void addRole(Role role) {
        this.roles.add(role);
    }

    public Set<? extends Name> getNames() {
        return null;
    }

    public Name addName() {
        return new MockName();
    }

    public Name addName(Type type) {
        return new MockName();
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public Role addRole(SorRole sorRole) {
        MockRole mockRole = new MockRole(sorRole);
        this.roles.add(mockRole);
        return mockRole;
    }

    public Set<Identifier> getIdentifiers() {
        HashSet<Identifier> identifiers = new HashSet<Identifier>();
        Identifier id = new Identifier(){

            public IdentifierType getType() {
                return new IdentifierType(){

                    public Long getId() {
                        return 1L;
                    }

                    public String getName() {
                        return "NETID";
                    }

                    public boolean equals(Object o) {
                        if (o == null) {
                            return false;
                        }
                        if (!(o instanceof IdentifierType)) {
                            return false;
                        }
                        IdentifierType idType = (IdentifierType)o;
                        return this.getName().equals(idType.getName());
                    }
                };
            }

            public String getValue() {
                return MockPerson.this.identifierValue;
            }

            public boolean isPrimary() {
                return true;
            }

            public boolean isDeleted() {
                return false;
            }

            public void setPrimary(boolean value) {
            }

            public void setDeleted(boolean value) {
            }

            public boolean equals(Object o) {
                if (o == null) {
                    return false;
                }
                if (!(o instanceof Identifier)) {
                    return false;
                }
                Identifier id = (Identifier)o;
                return MockPerson.this.identifierValue.equals(id.getValue()) && this.getType().equals(id.getType());
            }
        };
        identifiers.add(id);
        return identifiers;
    }

    public Identifier addIdentifier(IdentifierType identifierType, String value) {
        return null;
    }

    public Name getPreferredName() {
        return null;
    }

    public Name getOfficialName() {
        return null;
    }

    public String getGender() {
        return null;
    }

    public Date getDateOfBirth() {
        return null;
    }

    public void setDateOfBirth(Date dateOfBirth) {
    }

    public void setGender(String gender) {
    }

    public Identifier addIdentifier() {
        return null;
    }

    public Name addOfficialName() {
        MockName name = new MockName();
        name.setOfficialName(true);
        return name;
    }

    public Name addPreferredName() {
        MockName name = new MockName();
        name.setPreferredName(true);
        return name;
    }

    public void setPreferredName(Name name) {
    }

    public Role pickOutRole(String code) {
        return null;
    }

    public Identifier pickOutIdentifier(String name) {
        for (Identifier identifier : this.getIdentifiers()) {
            if (!identifier.getType().getName().equals(name)) continue;
            return identifier;
        }
        return null;
    }

    public ActivationKey generateNewActivationKey(Date start, Date end) {
        this.activationKey = new MockActivationKey(UUID.randomUUID().toString(), start, end);
        return this.activationKey;
    }

    public ActivationKey generateNewActivationKey(Date end) {
        this.activationKey = new MockActivationKey(UUID.randomUUID().toString(), new Date(), end);
        return this.activationKey;
    }

    public ActivationKey getCurrentActivationKey() {
        return this.activationKey;
    }

    public void removeCurrentActivationKey() {
        this.activationKey = null;
    }

    public Role findRoleBySoRRoleId(Long sorRoleId) {
        for (Role role : this.roles) {
            if (!sorRoleId.equals(role.getSorRoleId())) continue;
            return role;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockPerson that = (MockPerson)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return 31 * (int)(this.id ^ this.id >>> 32);
    }
}

