/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.plugin.mojo;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;
import org.jasig.portal.plugin.deployer.DeployerConfig;
import org.jasig.portal.plugin.deployer.EarDeployer;
import org.jasig.portal.plugin.mojo.AbstractDeployEarMojo;

@Mojo(name="deploy-ear-file", requiresProject=false)
public class DeployEarFileMojo
extends AbstractDeployEarMojo {
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(property="localRepository")
    private ArtifactRepository localRepository;
    @Parameter(property="project.remoteArtifactRepositories")
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="classifier")
    private String classifier;
    @Parameter(property="file")
    private File file;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File artifactFile;
        EarDeployer earDeployer = this.getEarDeployer();
        DeployerConfig deployerConfig = this.getDeployerConfig();
        if (this.file != null) {
            artifactFile = this.file;
        } else {
            Artifact artifact = this.repositorySystem.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, "ear", this.classifier);
            ArtifactResolutionRequest artifactResolutionRequest = new ArtifactResolutionRequest();
            artifactResolutionRequest.setArtifact(artifact);
            artifactResolutionRequest.setLocalRepository(this.localRepository);
            artifactResolutionRequest.setRemoteRepositories(this.remoteRepositories);
            this.repositorySystem.resolve(artifactResolutionRequest);
            artifactFile = artifact.getFile();
        }
        deployerConfig.setEarLocation(artifactFile);
        earDeployer.deploy(deployerConfig);
    }
}

