/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.plugin.deployer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.jasig.portal.plugin.deployer.ClasspathEntityResolver;
import org.jasig.portal.plugin.deployer.DeployerConfig;
import org.jasig.portal.plugin.deployer.EarDeployer;
import org.jasig.portal.plugin.deployer.WebModule;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractExtractingEarDeployer
extends AbstractLogEnabled
implements EarDeployer {
    private static final String DESCRIPTOR_PATH = "META-INF/application.xml";
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String WEB_MODULE_XPATH = "//application/module/web";
    private static final String WEB_URI_NODE_NAME = "web-uri";
    private static final String CONTEXT_ROOT_NODE_NAME = "context-root";

    @Override
    public final void deploy(DeployerConfig deployerConfig) throws MojoExecutionException, MojoFailureException {
        JarFile earFile = this.getEarFile(deployerConfig);
        Document descriptorDom = this.getDescriptorDom(earFile);
        NodeList webModules = this.getWebModules(descriptorDom);
        for (int index = 0; index < webModules.getLength(); ++index) {
            Node webModuleNode = webModules.item(index);
            WebModule webModuleInfo = this.getWebModuleInfo(webModuleNode);
            this.deployWar(webModuleInfo, earFile, deployerConfig);
        }
        Enumeration<JarEntry> earEntries = earFile.entries();
        while (earEntries.hasMoreElements()) {
            JarEntry entry = earEntries.nextElement();
            if (!entry.getName().endsWith(".jar")) continue;
            this.deployJar(entry, earFile, deployerConfig);
        }
    }

    protected abstract void deployWar(WebModule var1, JarFile var2, DeployerConfig var3) throws MojoFailureException;

    protected abstract void deployJar(JarEntry var1, JarFile var2, DeployerConfig var3) throws MojoFailureException;

    protected JarFile getEarFile(DeployerConfig deployerConfig) throws MojoExecutionException, MojoFailureException {
        File earLocation = deployerConfig.getEarLocation();
        if (earLocation == null) {
            throw new MojoExecutionException("No earLocation specified");
        }
        try {
            return new JarFile(earLocation);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to open '" + earLocation + " as a JAR file", (Throwable)e);
        }
    }

    protected Document getDescriptorDom(JarFile earFile) throws MojoFailureException {
        ZipEntry descriptorEntry = earFile.getEntry(DESCRIPTOR_PATH);
        if (descriptorEntry == null) {
            throw new IllegalArgumentException("JarFile '" + earFile + "' does not contain a descriptor at '" + DESCRIPTOR_PATH + "'");
        }
        InputStream descriptorStream = null;
        try {
            DocumentBuilder docBuilder;
            descriptorStream = earFile.getInputStream(descriptorEntry);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                docBuilder = docBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                throw new RuntimeException("Failed to create DocumentBuilder to parse EAR descriptor.", pce);
            }
            docBuilder.setEntityResolver(new ClasspathEntityResolver(this.getLogger()));
            try {
                Document descriptorDom;
                Document document = descriptorDom = docBuilder.parse(descriptorStream);
                return document;
            }
            catch (SAXException e) {
                try {
                    throw new MojoFailureException("Failed to parse descriptor 'META-INF/application.xml' from EAR '" + earFile.getName() + "'", (Throwable)e);
                }
                catch (IOException e2) {
                    throw new MojoFailureException("Failed to read descriptor 'META-INF/application.xml' from EAR '" + earFile.getName() + "'", (Throwable)e2);
                }
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)descriptorStream);
        }
    }

    protected NodeList getWebModules(Document descriptorDom) {
        XPathExpression xpathExpr;
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        try {
            xpathExpr = xpath.compile(WEB_MODULE_XPATH);
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException("Failed to compile XPathExpression from '//application/module/web'", xpee);
        }
        try {
            NodeList nodes = (NodeList)xpathExpr.evaluate(descriptorDom, XPathConstants.NODESET);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Found " + nodes.getLength() + " '" + WEB_MODULE_XPATH + "' nodes in descriptor.");
            }
            return nodes;
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException("Failed to evaluate XPathExpression='" + xpathExpr + "'", xpee);
        }
    }

    protected WebModule getWebModuleInfo(Node webModuleNode) {
        if (!"web".equals(this.getNodeName(webModuleNode))) {
            throw new IllegalArgumentException("webModuleNode must be a 'web' Node");
        }
        String webUri = null;
        String contextRoot = null;
        NodeList childNodes = webModuleNode.getChildNodes();
        for (int index = 0; index < childNodes.getLength() && (webUri == null || contextRoot == null); ++index) {
            Node node = childNodes.item(index);
            String nodeName = this.getNodeName(node);
            if (WEB_URI_NODE_NAME.equals(nodeName)) {
                webUri = StringUtils.strip((String)node.getTextContent());
                continue;
            }
            if (!CONTEXT_ROOT_NODE_NAME.equals(nodeName)) continue;
            contextRoot = StringUtils.strip((String)node.getTextContent());
        }
        if (webUri == null || contextRoot == null) {
            throw new IllegalArgumentException("Node '" + webModuleNode + "' did not contain the nessesary information to create a WebModule. webUri='" + webUri + "', contextRoot='" + contextRoot + "'");
        }
        WebModule webModule = new WebModule();
        webModule.setWebUri(webUri);
        webModule.setContextRoot(contextRoot);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Found WebModule='" + webModule + "'");
        }
        return webModule;
    }

    protected File createSafeFile(File baseDir, String fileName) throws IOException {
        File safeFile = new File(baseDir, fileName);
        if (safeFile.exists()) {
            safeFile.delete();
        } else {
            FileUtils.forceMkdir((File)baseDir);
        }
        return safeFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyAndClose(JarEntry earEntry, JarFile earFile, File destinationFile) throws MojoFailureException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Copying EAR entry '" + earFile.getName() + "!" + earEntry.getName() + "' to '" + destinationFile + "'");
        }
        InputStream jarEntryStream = null;
        try {
            jarEntryStream = earFile.getInputStream(earEntry);
            FileOutputStream jarOutStream = new FileOutputStream(destinationFile);
            try {
                IOUtils.copy((InputStream)jarEntryStream, (OutputStream)jarOutStream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)jarOutStream);
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to copy EAR entry '" + earEntry.getName() + "' out of '" + earFile.getName() + "' to '" + destinationFile + "'", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)jarEntryStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractWar(JarFile earFile, JarEntry earEntry, File contextDir) throws MojoFailureException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Extracting EAR entry '" + earFile.getName() + "!" + earEntry.getName() + "' to '" + contextDir + "'");
        }
        if (!contextDir.exists()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Creating context directory entry '" + contextDir + "'");
            }
            try {
                FileUtils.forceMkdir((File)contextDir);
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to create '" + contextDir + "' to extract '" + earEntry.getName() + "' out of '" + earFile.getName() + "' into", (Throwable)e);
            }
        }
        JarInputStream warInputStream = null;
        try {
            JarEntry warEntry;
            warInputStream = new JarInputStream(earFile.getInputStream(earEntry));
            Manifest manifest = warInputStream.getManifest();
            if (manifest != null) {
                FileOutputStream manifestFileOutputStream = null;
                try {
                    File manifestFile = new File(contextDir, MANIFEST_PATH);
                    manifestFile.getParentFile().mkdirs();
                    manifestFileOutputStream = new FileOutputStream(manifestFile);
                    manifest.write(manifestFileOutputStream);
                }
                catch (Exception e) {
                    this.getLogger().error("Failed to copy the MANIFEST.MF file for ear entry '" + earEntry.getName() + "' out of '" + earFile.getName() + "'", (Throwable)e);
                    throw new MojoFailureException("Failed to copy the MANIFEST.MF file for ear entry '" + earEntry.getName() + "' out of '" + earFile.getName() + "'", (Throwable)e);
                }
                finally {
                    try {
                        if (manifestFileOutputStream != null) {
                            manifestFileOutputStream.close();
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().warn("Error closing the OutputStream for MANIFEST.MF in warEntry:  " + earEntry.getName());
                    }
                }
            }
            while ((warEntry = warInputStream.getNextJarEntry()) != null) {
                File warEntryFile = new File(contextDir, warEntry.getName());
                if (warEntry.isDirectory()) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Creating WAR directory entry '" + earEntry.getName() + "!" + warEntry.getName() + "' as '" + warEntryFile + "'");
                    }
                    FileUtils.forceMkdir((File)warEntryFile);
                    continue;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Extracting WAR entry '" + earEntry.getName() + "!" + warEntry.getName() + "' to '" + warEntryFile + "'");
                }
                FileUtils.forceMkdir((File)warEntryFile.getParentFile());
                FileOutputStream jarEntryFileOutputStream = new FileOutputStream(warEntryFile);
                try {
                    IOUtils.copy((InputStream)warInputStream, (OutputStream)jarEntryFileOutputStream);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)jarEntryFileOutputStream);
                }
            }
        }
        catch (IOException e) {
            try {
                throw new MojoFailureException("Failed to extract EAR entry '" + earEntry.getName() + "' out of '" + earFile.getName() + "' to '" + contextDir + "'", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(warInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)warInputStream);
    }

    private String getNodeName(Node node) {
        if (node.getNamespaceURI() == null) {
            return node.getNodeName();
        }
        return node.getLocalName();
    }
}

