/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.plugin.deployer;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.component.annotations.Component;
import org.jasig.portal.plugin.deployer.AbstractExtractingEarDeployer;
import org.jasig.portal.plugin.deployer.DeployerConfig;
import org.jasig.portal.plugin.deployer.EarDeployer;
import org.jasig.portal.plugin.deployer.WebModule;

@Component(role=EarDeployer.class, hint="tomcat")
public class TomcatEarDeployer
extends AbstractExtractingEarDeployer {
    private static final String WEB_APPS_DIR_PARAM = "webAppsDir";
    private static final String SHARED_LIB_DIR_PARAM = "sharedLibDir";

    private File getWebAppsDir(DeployerConfig config) {
        return this.getFileParam(config, WEB_APPS_DIR_PARAM, "webapps");
    }

    private File getSharedLibDir(DeployerConfig config) {
        return this.getFileParam(config, SHARED_LIB_DIR_PARAM, "shared/lib");
    }

    private File getFileParam(DeployerConfig config, String param, String defaultLocation) {
        Map<String, String> deployerParameters = config.getDeployerParameters();
        String paramLocation = deployerParameters.get(param);
        if (paramLocation == null) {
            paramLocation = defaultLocation;
        }
        if (paramLocation.startsWith("/")) {
            return new File(paramLocation);
        }
        return new File(config.getDeployDestination(), paramLocation);
    }

    @Override
    protected final void deployWar(WebModule webModule, JarFile earFile, DeployerConfig deployerConfig) throws MojoFailureException {
        File contextDir;
        String webUri = webModule.getWebUri();
        JarEntry warEntry = earFile.getJarEntry(webUri);
        File webappsDir = this.getWebAppsDir(deployerConfig);
        String contextName = webModule.getContextRoot();
        if (contextName.endsWith(".war")) {
            contextName = contextName.substring(contextName.length() - 4);
        }
        if (contextName.startsWith("/")) {
            contextName = contextName.substring(1);
        }
        if (deployerConfig.isRemoveExistingWebappDirectories() && (contextDir = new File(webappsDir, contextName)).exists()) {
            try {
                FileUtils.deleteDirectory((File)contextDir);
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to remove webapp context directory: " + contextDir, (Throwable)e);
            }
        }
        if (deployerConfig.isExtractWars()) {
            contextDir = new File(webappsDir, contextName);
            this.extractWar(earFile, warEntry, contextDir);
        } else {
            File warDest;
            String warName = contextName = contextName + ".war";
            try {
                warDest = this.createSafeFile(webappsDir, warName);
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to setup File to deploy '" + warName + "' to '" + webappsDir + "'", (Throwable)e);
            }
            this.copyAndClose(warEntry, earFile, warDest);
        }
    }

    @Override
    protected final void deployJar(JarEntry jarEntry, JarFile earFile, DeployerConfig deployerConfig) throws MojoFailureException {
        File jarDest;
        String jarName = jarEntry.getName();
        if (jarName.contains("/")) {
            throw new IllegalArgumentException("The EAR contains a JAR entry in a folder, this is not supported. Bad Jar: '" + jarName + "'");
        }
        File sharedLibDir = this.getSharedLibDir(deployerConfig);
        try {
            jarDest = this.createSafeFile(sharedLibDir, jarName);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to setup File to deploy '" + jarName + "' to '" + sharedLibDir + "'", (Throwable)e);
        }
        this.copyAndClose(jarEntry, earFile, jarDest);
    }
}

