/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.sax;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClasspathEntityResolver
implements EntityResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String entityName = this.getEntityName(systemId);
        InputStream entityStream = this.getClass().getResourceAsStream(entityName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)((entityStream == null ? "Failed to resolve" : "Resolved") + " Entity for publicId: '" + publicId + "', systemId: '" + systemId + "'"));
        }
        if (entityStream != null) {
            return new InputSource(entityStream);
        }
        return null;
    }

    protected String getEntityName(String systemId) {
        int lastSlashIndex = systemId.lastIndexOf(47);
        if (lastSlashIndex < 0) {
            return systemId;
        }
        String entityName = systemId.substring(lastSlashIndex);
        return entityName;
    }
}

