/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.jasig.portal.ChannelCategory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.PortalException;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupConstants;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.GroupService;

@Deprecated
public abstract class AbstractChannelRegistryStore
implements IChannelRegistryStore {
    @Override
    public void addCategoryToCategory(ChannelCategory child, ChannelCategory parent) throws GroupsException {
        String childKey = String.valueOf(child.getId());
        IEntityGroup childGroup = GroupService.findGroup(childKey);
        String parentKey = String.valueOf(parent.getId());
        IEntityGroup parentGroup = GroupService.findGroup(parentKey);
        parentGroup.addMember(childGroup);
        parentGroup.updateMembers();
    }

    @Override
    public void addChannelToCategory(IChannelDefinition channelDef, ChannelCategory category) throws PortalException {
        String channelDefKey = String.valueOf(channelDef.getId());
        IEntity channelDefEntity = GroupService.getEntity(channelDefKey, IChannelDefinition.class);
        IEntityGroup categoryGroup = GroupService.findGroup(category.getId());
        categoryGroup.addMember(channelDefEntity);
        categoryGroup.updateMembers();
    }

    @Override
    public void approveChannelDefinition(IChannelDefinition channelDef, IPerson approver, Date approveDate) {
        channelDef.setApproverId(approver.getID());
        channelDef.setApprovalDate(approveDate);
        this.saveChannelDefinition(channelDef);
    }

    @Override
    public void deleteChannelCategory(ChannelCategory category) throws GroupsException {
        String key = String.valueOf(category.getId());
        ILockableEntityGroup categoryGroup = GroupService.findLockableGroup(key, "UP_FRAMEWORK");
        categoryGroup.delete();
    }

    @Override
    public void disapproveChannelDefinition(IChannelDefinition channelDef) {
        channelDef.setApproverId(-1);
        channelDef.setApprovalDate(null);
        this.saveChannelDefinition(channelDef);
    }

    @Override
    public ChannelCategory[] getAllChildCategories(ChannelCategory parent) {
        HashSet<ChannelCategory> rslt = new HashSet<ChannelCategory>();
        for (ChannelCategory child : this.getChildCategories(parent)) {
            rslt.add(child);
            rslt.addAll(Arrays.asList(this.getAllChildCategories(child)));
        }
        return rslt.toArray(new ChannelCategory[0]);
    }

    @Override
    public IChannelDefinition[] getAllChildChannels(ChannelCategory parent) {
        HashSet<IChannelDefinition> rslt = new HashSet<IChannelDefinition>();
        try {
            for (IChannelDefinition channel : this.getChildChannels(parent)) {
                rslt.add(channel);
            }
            for (ChannelCategory category : this.getAllChildCategories(parent)) {
                for (IChannelDefinition channel : this.getChildChannels(category)) {
                    rslt.add(channel);
                }
            }
        }
        catch (Exception e) {
            String msg = "Failed to obtain child channels for the specified parent '" + parent.getName() + "', id=" + parent.getId();
            throw new PortalException(msg, (Throwable)e);
        }
        return rslt.toArray(new IChannelDefinition[0]);
    }

    @Override
    public IChannelDefinition[] getAllChildChannels(ChannelCategory parent, IPerson person) {
        HashSet<IChannelDefinition> rslt = new HashSet<IChannelDefinition>();
        try {
            for (IChannelDefinition channel : this.getChildChannels(parent, person)) {
                rslt.add(channel);
            }
            for (ChannelCategory category : this.getAllChildCategories(parent)) {
                for (IChannelDefinition channel : this.getChildChannels(category, person)) {
                    rslt.add(channel);
                }
            }
        }
        catch (Exception e) {
            String msg = "Failed to obtain child channels for the specified parent '" + parent.getName() + "', id=" + parent.getId();
            throw new PortalException(msg, (Throwable)e);
        }
        return rslt.toArray(new IChannelDefinition[0]);
    }

    @Override
    public IChannelDefinition[] getAllManageableChildChannels(ChannelCategory parent, IPerson person) {
        HashSet<IChannelDefinition> rslt = new HashSet<IChannelDefinition>();
        try {
            for (IChannelDefinition channel : this.getManageableChildChannels(parent, person)) {
                rslt.add(channel);
            }
            for (ChannelCategory category : this.getAllChildCategories(parent)) {
                for (IChannelDefinition channel : this.getManageableChildChannels(category, person)) {
                    rslt.add(channel);
                }
            }
        }
        catch (Exception e) {
            String msg = "Failed to obtain child channels for the specified parent '" + parent.getName() + "', id=" + parent.getId();
            throw new PortalException(msg, (Throwable)e);
        }
        return rslt.toArray(new IChannelDefinition[0]);
    }

    @Override
    public ChannelCategory getChannelCategory(String channelCategoryId) throws GroupsException {
        IEntityGroup categoryGroup = GroupService.findGroup(channelCategoryId);
        ChannelCategory category = new ChannelCategory(channelCategoryId);
        category.setName(categoryGroup.getName());
        category.setDescription(categoryGroup.getDescription());
        category.setCreatorId(categoryGroup.getCreatorID());
        return category;
    }

    @Override
    public ChannelCategory[] getChildCategories(ChannelCategory parent) throws GroupsException {
        String parentKey = String.valueOf(parent.getId());
        IEntityGroup parentGroup = GroupService.findGroup(parentKey);
        HashSet<ChannelCategory> categories = new HashSet<ChannelCategory>();
        Iterator iter = parentGroup.getMembers();
        while (iter.hasNext()) {
            IGroupMember gm = (IGroupMember)iter.next();
            if (!gm.isGroup()) continue;
            String categoryId = gm.getKey();
            categories.add(this.getChannelCategory(categoryId));
        }
        return categories.toArray(new ChannelCategory[0]);
    }

    @Override
    public IChannelDefinition[] getChildChannels(ChannelCategory parent) {
        String parentKey = String.valueOf(parent.getId());
        IEntityGroup parentGroup = GroupService.findGroup(parentKey);
        HashSet<IChannelDefinition> channelDefs = new HashSet<IChannelDefinition>();
        Iterator iter = parentGroup.getMembers();
        while (iter.hasNext()) {
            IGroupMember gm = (IGroupMember)iter.next();
            if (!gm.isEntity()) continue;
            int channelPublishId = Integer.parseInt(gm.getKey());
            channelDefs.add(this.getChannelDefinition(channelPublishId));
        }
        return channelDefs.toArray(new IChannelDefinition[channelDefs.size()]);
    }

    @Override
    public IChannelDefinition[] getChildChannels(ChannelCategory parent, IPerson person) {
        EntityIdentifier ei = person.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        String parentKey = String.valueOf(parent.getId());
        IEntityGroup parentGroup = GroupService.findGroup(parentKey);
        HashSet<IChannelDefinition> channelDefs = new HashSet<IChannelDefinition>();
        Iterator iter = parentGroup.getMembers();
        while (iter.hasNext()) {
            int channelPublishId;
            IGroupMember gm = (IGroupMember)iter.next();
            if (!gm.isEntity() || !ap.canSubscribe(channelPublishId = Integer.parseInt(gm.getKey()))) continue;
            channelDefs.add(this.getChannelDefinition(channelPublishId));
        }
        return channelDefs.toArray(new IChannelDefinition[channelDefs.size()]);
    }

    @Override
    public IChannelDefinition[] getManageableChildChannels(ChannelCategory parent, IPerson person) {
        EntityIdentifier ei = person.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        String parentKey = String.valueOf(parent.getId());
        IEntityGroup parentGroup = GroupService.findGroup(parentKey);
        HashSet<IChannelDefinition> channelDefs = new HashSet<IChannelDefinition>();
        Iterator iter = parentGroup.getMembers();
        while (iter.hasNext()) {
            int channelPublishId;
            IGroupMember gm = (IGroupMember)iter.next();
            if (!gm.isEntity() || !ap.canManage(channelPublishId = Integer.parseInt(gm.getKey()))) continue;
            channelDefs.add(this.getChannelDefinition(channelPublishId));
        }
        return channelDefs.toArray(new IChannelDefinition[channelDefs.size()]);
    }

    @Override
    public ChannelCategory[] getParentCategories(ChannelCategory child) throws GroupsException {
        String childKey = String.valueOf(child.getId());
        IEntityGroup childGroup = GroupService.findGroup(childKey);
        HashSet<ChannelCategory> parents = new HashSet<ChannelCategory>();
        Iterator iter = childGroup.getContainingGroups();
        while (iter.hasNext()) {
            IGroupMember gm = (IGroupMember)iter.next();
            if (!gm.isGroup()) continue;
            String categoryId = gm.getKey();
            parents.add(this.getChannelCategory(categoryId));
        }
        return parents.toArray(new ChannelCategory[0]);
    }

    @Override
    public ChannelCategory[] getParentCategories(IChannelDefinition child) throws GroupsException {
        String childKey = String.valueOf(child.getId());
        IEntity childEntity = GroupService.getEntity(childKey, IChannelDefinition.class);
        HashSet<ChannelCategory> parents = new HashSet<ChannelCategory>();
        Iterator iter = childEntity.getContainingGroups();
        while (iter.hasNext()) {
            IGroupMember gm = (IGroupMember)iter.next();
            if (!gm.isGroup()) continue;
            String categoryId = gm.getKey();
            parents.add(this.getChannelCategory(categoryId));
        }
        return parents.toArray(new ChannelCategory[0]);
    }

    @Override
    public ChannelCategory getTopLevelChannelCategory() throws GroupsException {
        IEntityGroup categoryGroup = GroupService.getDistinguishedGroup(IGroupConstants.CHANNEL_CATEGORIES);
        return this.getChannelCategory(categoryGroup.getKey());
    }

    @Override
    public ChannelCategory newChannelCategory() throws GroupsException {
        IEntityGroup categoryGroup = GroupService.newGroup(IChannelDefinition.class);
        categoryGroup.setName("");
        categoryGroup.setCreatorID("");
        categoryGroup.update();
        String id = categoryGroup.getKey();
        return new ChannelCategory(id);
    }

    @Override
    public ChannelCategory newChannelCategory(String name, String description, String creatorId) throws GroupsException {
        IEntityGroup categoryGroup = GroupService.newGroup(IChannelDefinition.class);
        categoryGroup.setName(name);
        categoryGroup.setCreatorID(creatorId);
        categoryGroup.setDescription(description);
        categoryGroup.update();
        String id = categoryGroup.getKey();
        ChannelCategory cat = new ChannelCategory(id);
        cat.setName(name);
        cat.setDescription(description);
        cat.setCreatorId(creatorId);
        return cat;
    }

    @Override
    public void removeCategoryFromCategory(ChannelCategory child, ChannelCategory parent) throws GroupsException {
        String childKey = String.valueOf(child.getId());
        IEntityGroup childGroup = GroupService.findGroup(childKey);
        String parentKey = String.valueOf(parent.getId());
        IEntityGroup parentGroup = GroupService.findGroup(parentKey);
        parentGroup.removeMember(childGroup);
        parentGroup.updateMembers();
    }

    @Override
    public void removeChannelFromCategory(IChannelDefinition channelDef, ChannelCategory category) throws PortalException {
        String channelDefKey = String.valueOf(channelDef.getId());
        IEntity channelDefEntity = GroupService.getEntity(channelDefKey, IChannelDefinition.class);
        String categoryKey = String.valueOf(category.getId());
        IEntityGroup categoryGroup = GroupService.findGroup(categoryKey);
        categoryGroup.removeMember(channelDefEntity);
        categoryGroup.updateMembers();
    }

    @Override
    public void saveChannelCategory(ChannelCategory category) throws GroupsException {
        IEntityGroup categoryGroup = GroupService.findGroup(category.getId());
        categoryGroup.setName(category.getName());
        categoryGroup.setDescription(category.getDescription());
        categoryGroup.setCreatorID(category.getCreatorId());
        categoryGroup.update();
    }
}

